/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.jmx;

import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.jmx.JmxCommonDeviceMBean;
import de.intarsys.tools.license.LicenseEnvironment;
import javax.management.NotificationBroadcasterSupport;

public class JmxCommonDevice<T extends CommonDevice>
extends NotificationBroadcasterSupport
implements JmxCommonDeviceMBean {
    private final T device;

    public JmxCommonDevice(T device) {
        this.device = device;
    }

    public T getDevice() {
        return this.device;
    }

    @Override
    public String getId() {
        return ((CommonDevice)this.device).getId();
    }

    @Override
    public String getState() {
        return ((CommonDevice)this.getDevice()).getState().getId();
    }

    @Override
    public String getStateReason() {
        return ((CommonDevice)this.getDevice()).getStateReason();
    }

    @Override
    public String getType() {
        return this.device.getClass().getName();
    }

    @Override
    public boolean isEnabled() {
        return ((CommonDevice)this.getDevice()).isEnabled();
    }

    @Override
    public boolean isLicensed() {
        return ((CommonDevice)this.device).getLicenseProduct() == null || LicenseEnvironment.get().getLicenseProductState(((CommonDevice)this.device).getLicenseProduct()).isValid();
    }
}

