/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.common;

import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.IX509Principal;
import de.intarsys.security.device.common.PrincipalWrapper;
import de.intarsys.tools.encoding.Base64;
import java.security.cert.CertificateEncodingException;

public class X509PrincipalWrapper
extends PrincipalWrapper {
    protected X509PrincipalWrapper(IPrincipal principal) {
        super(principal);
    }

    public String getCertificateBase64() {
        try {
            return new String(Base64.encode((byte[])this.getPrincipal().getEncodedCertificate()));
        }
        catch (CertificateEncodingException e) {
            return "";
        }
    }

    public String getIssuer() {
        return this.getPrincipal().getJavaCertificate().getIssuerX500Principal().toString();
    }

    @Override
    protected IX509Principal getPrincipal() {
        return (IX509Principal)super.getPrincipal();
    }

    public String getSerialNumber() {
        return this.getPrincipal().getSerialNumber();
    }

    public String getSignatureAlgorithm() {
        return this.getPrincipal().getX509PublicKeyCertificate().getSigAlgName();
    }

    public String getSubject() {
        return this.getPrincipal().getJavaCertificate().getSubjectX500Principal().toString();
    }

    public boolean isKeyOwner() {
        return this.getPrincipal().isKeyOwner();
    }

    public boolean isKeyUsageCrlSign() {
        return this.getPrincipal().isKeyUsage("cRLSign");
    }

    public boolean isKeyUsageDataEncipherment() {
        return this.getPrincipal().isKeyUsage("dataEncipherment");
    }

    public boolean isKeyUsageDecipherOnly() {
        return this.getPrincipal().isKeyUsage("decipherOnly");
    }

    public boolean isKeyUsageDigitalSignature() {
        return this.getPrincipal().isKeyUsage("digitalSignature");
    }

    public boolean isKeyUsageEncipherOnly() {
        return this.getPrincipal().isKeyUsage("encipherOnly");
    }

    public boolean isKeyUsageKeyAgreement() {
        return this.getPrincipal().isKeyUsage("keyAgreement");
    }

    public boolean isKeyUsageKeyCertSign() {
        return this.getPrincipal().isKeyUsage("keyCertSign");
    }

    public boolean isKeyUsageKeyEncipherment() {
        return this.getPrincipal().isKeyUsage("keyEncipherment");
    }

    public boolean isKeyUsageNonRepudiation() {
        return this.getPrincipal().isKeyUsage("nonRepudiation");
    }

    public boolean isQualified() {
        return this.getPrincipal().isQualified();
    }

    public boolean isSupportsAuthentication() {
        try {
            return this.getPrincipal().supportsApplication("Authentication");
        }
        catch (SecurityApplicationException e) {
            return false;
        }
    }

    public boolean isSupportsEncryption() {
        try {
            return this.getPrincipal().supportsApplication("Encryption");
        }
        catch (SecurityApplicationException e) {
            return false;
        }
    }

    public boolean isSupportsSignature() {
        try {
            return this.getPrincipal().supportsApplication("Signature");
        }
        catch (SecurityApplicationException e) {
            return false;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("serial=");
        sb.append(this.getSerialNumber());
        return sb.toString();
    }
}

