/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.common;

import de.intarsys.security.app.ApplicationException;
import de.intarsys.security.app.IApplication;
import de.intarsys.security.device.EnumDeviceState;
import de.intarsys.security.device.ICredential;
import de.intarsys.security.device.ICredentialFilter;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.IDeviceProvider;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.IPrincipalFilter;
import de.intarsys.tools.collection.ConversionIterator;
import de.intarsys.tools.collection.FilterIterator;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.license.EnumLicenseState;
import de.intarsys.tools.license.ILicenseStateSupport;
import de.intarsys.tools.notice.INotice;
import de.intarsys.tools.reflect.FieldException;
import de.intarsys.tools.reflect.IWrapper;
import de.intarsys.tools.reflect.InvocableMethod;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.Iterator;
import java.util.List;

public class DelegatingDevice<PD extends IDeviceProvider<?>, PO extends IDeviceProvider<?>>
implements IDevice,
IWrapper<IDevice>,
ILicenseStateSupport {
    private final IDevice delegate;
    private final PO deviceProvider;

    public DelegatingDevice(IDevice delegate) {
        this(delegate, delegate.getDeviceProvider());
    }

    public DelegatingDevice(IDevice delegate, PO deviceProvider) {
        this.delegate = delegate;
        this.deviceProvider = deviceProvider;
    }

    public void addNotice(INotice notice) {
        this.delegate.addNotice(notice);
    }

    public <T extends Event> void addNotificationListener(EventType<? extends T> type, INotificationListener<T> listener) {
        this.delegate.addNotificationListener(type, listener);
    }

    protected Iterator<ICredential> basicListCredentials(ICredentialFilter filter) {
        return this.delegate.listCredentials(filter);
    }

    protected Iterator<IPrincipal> basicListPrincipals(IPrincipalFilter filter) {
        return this.delegate.listPrincipals(filter);
    }

    public void clearNotices() {
        this.delegate.clearNotices();
    }

    @Override
    public Object control(String command, IArgs args) throws ApplicationException {
        return this.delegate.control(command, args);
    }

    @Override
    public IApplication createApplication(String id, IArgs args) throws ObjectCreationException {
        return this.delegate.createApplication(id, args);
    }

    public Object getAttribute(Object key) {
        return this.delegate.getAttribute(key);
    }

    public IDevice getDelegate() {
        return this.delegate;
    }

    public PO getDeviceProvider() {
        return this.deviceProvider;
    }

    public String getId() {
        return this.delegate.getId();
    }

    public EnumLicenseState getLicenseState() {
        IDevice iDevice = this.delegate;
        if (iDevice instanceof ILicenseStateSupport) {
            ILicenseStateSupport lss = (ILicenseStateSupport)iDevice;
            return lss.getLicenseState();
        }
        return EnumLicenseState.VALID;
    }

    public List<INotice> getNotices() {
        return this.delegate.getNotices();
    }

    @Override
    public EnumDeviceState getState() {
        return this.delegate.getState();
    }

    @InvocableMethod
    public Object getValue(String name) throws FieldException {
        return this.delegate.getValue(name);
    }

    public IDevice getWrapped() {
        return this.delegate;
    }

    protected boolean hookAcceptCredential(ICredential object) {
        return true;
    }

    protected boolean hookAcceptPrincipal(IPrincipal object) {
        return true;
    }

    protected ICredential hookConvertCredential(ICredential sourceObject) {
        return sourceObject;
    }

    protected IPrincipal hookConvertPrincipal(IPrincipal sourceObject) {
        return sourceObject;
    }

    @Override
    public Iterator<ICredential> listCredentials(ICredentialFilter filter) {
        Iterator<ICredential> it = this.basicListCredentials(filter);
        FilterIterator<ICredential> itFiltered = new FilterIterator<ICredential>(it){

            protected boolean accept(ICredential object) {
                return DelegatingDevice.this.hookAcceptCredential(object);
            }
        };
        return new ConversionIterator<ICredential, ICredential>((Iterator)itFiltered){

            protected ICredential createTargetObject(ICredential sourceObject) {
                return DelegatingDevice.this.hookConvertCredential(sourceObject);
            }
        };
    }

    @Override
    public Iterator<IPrincipal> listPrincipals(IPrincipalFilter filter) {
        Iterator<IPrincipal> it = this.basicListPrincipals(filter);
        FilterIterator<IPrincipal> itFiltered = new FilterIterator<IPrincipal>(it){

            protected boolean accept(IPrincipal object) {
                return DelegatingDevice.this.hookAcceptPrincipal(object);
            }
        };
        return new ConversionIterator<IPrincipal, IPrincipal>((Iterator)itFiltered){

            protected IPrincipal createTargetObject(IPrincipal sourceObject) {
                return DelegatingDevice.this.hookConvertPrincipal(sourceObject);
            }
        };
    }

    @Override
    public void refresh() {
        this.delegate.refresh();
    }

    public Object removeAttribute(Object key) {
        return this.delegate.removeAttribute(key);
    }

    public boolean removeNotice(INotice notice) {
        return this.delegate.removeNotice(notice);
    }

    public <T extends Event> void removeNotificationListener(EventType<? extends T> type, INotificationListener<T> listener) {
        this.delegate.removeNotificationListener(type, listener);
    }

    public Object setAttribute(Object key, Object value) {
        return this.delegate.setAttribute(key, value);
    }

    public Object setValue(String name, Object value) throws FieldException {
        return this.delegate.setValue(name, value);
    }
}

