/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device;

import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.DeviceProviderRegistry;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.IDeviceFilter;
import de.intarsys.security.device.IDeviceProvider;
import de.intarsys.security.device.IDeviceProviderRegistry;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.tools.factory.InstanceSpec;
import de.intarsys.tools.format.Format;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.reflect.ObjectTools;
import de.intarsys.tools.string.StringTools;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DeviceTools {
    public static IDevice detectDevice(IX509PublicKeyCertificate certificate) throws ObjectCreationException {
        IDeviceProvider deviceProvider = DeviceTools.toDeviceProvider("de.intarsys.security.device.keystore.device.KeystoreDeviceProvider");
        IDevice device = (IDevice)deviceProvider.listDevices(null).next();
        return device;
    }

    public static IDevice getDefaultDevice(Object deviceProvider) throws ObjectCreationException {
        IDeviceProvider expectedDeviceProvider = DeviceTools.toDeviceProvider(deviceProvider);
        if (expectedDeviceProvider == null) {
            return null;
        }
        Iterator it = expectedDeviceProvider.listDevices(null);
        if (it.hasNext()) {
            return (IDevice)it.next();
        }
        throw new ObjectCreationException(Format.simple((String)"device provider '{}' has no devices", (Object[])new Object[]{expectedDeviceProvider}));
    }

    public static IDevice getDevice(IArgs args, String name) throws ObjectCreationException {
        Object deviceProvider = args.get(name + "Provider");
        Object device = args.get(name);
        return device == null ? DeviceTools.getDefaultDevice(deviceProvider) : DeviceTools.toDevice(deviceProvider, device);
    }

    public static IDevice getDevice(IArgs args, String name, Object deviceProvider) throws ObjectCreationException {
        Object device = args.get(name);
        if (device == null) {
            return DeviceTools.getDefaultDevice(deviceProvider);
        }
        return DeviceTools.toDevice(deviceProvider, device);
    }

    public static IDeviceProvider getDeviceProvider(IArgs args, String name) throws ObjectCreationException {
        Object value = args.get(name);
        return DeviceTools.toDeviceProvider(value);
    }

    public static IPrincipal getPrincipal(IArgs args, String name) {
        Object value = args.get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof IPrincipal) {
            return (IPrincipal)value;
        }
        throw new IllegalArgumentException("argument '" + name + "' not a principal");
    }

    public static <T extends IDevice> T lookupDevice(IDeviceProvider<T> provider, final String id) {
        if (StringTools.isEmpty((String)id)) {
            return null;
        }
        if (provider == null) {
            throw new IllegalArgumentException("'" + id + "' device unknown provider");
        }
        Iterator<T> devices = provider.listDevices(new IDeviceFilter(){

            @Override
            public boolean accept(IDevice device) {
                return id.equals(device.getId());
            }
        });
        if (devices.hasNext()) {
            return (T)((IDevice)devices.next());
        }
        return null;
    }

    public static <T> T lookupDeviceProvider(Class<T> clazz) {
        List<T> providers = DeviceTools.lookupDeviceProviders(clazz);
        if (providers.isEmpty()) {
            return null;
        }
        return providers.get(0);
    }

    public static <T> List<T> lookupDeviceProviders(Class<T> clazz) {
        ArrayList providers = new ArrayList();
        IDeviceProviderRegistry deviceProviderRegistry = DeviceProviderRegistry.get();
        for (IDeviceProvider<?> deviceProvider : deviceProviderRegistry.getDeviceProviders()) {
            if (!clazz.isInstance(deviceProvider)) continue;
            providers.add(deviceProvider);
        }
        return providers;
    }

    public static String sanitizeId(String id) {
        return id.replaceAll("[^a-zA-Z0-9_-]", "-");
    }

    public static IDevice toDevice(Object deviceProvider, Object device) throws ObjectCreationException {
        IDeviceProvider expectedDeviceProvider = DeviceTools.toDeviceProvider(deviceProvider);
        if (device instanceof IDevice) {
            return (IDevice)device;
        }
        if (device == null) {
            return null;
        }
        if (device instanceof IArgs) {
            IArgs args = (IArgs)device;
            InstanceSpec spec = InstanceSpec.createFromArgs(IDevice.class, (Object)args);
            if (spec == null || spec.getFactory() == null) {
                return null;
            }
            IDevice tmpDevice = (IDevice)spec.createInstance();
            return tmpDevice;
        }
        if (device instanceof String) {
            Object tmpDevice;
            String fullName = (String)device;
            if (StringTools.isEmpty((String)fullName)) {
                return null;
            }
            String[] components = fullName.split("@", 2);
            String localName = components[0];
            IDeviceProvider tmpDeviceProvider = expectedDeviceProvider;
            if (components.length > 1) {
                tmpDeviceProvider = DeviceTools.toDeviceProvider(components[1]);
            }
            if ((tmpDevice = DeviceTools.lookupDevice(tmpDeviceProvider, localName)) == null) {
                throw new ObjectCreationException(Format.simple((String)"device '{}' not found", (Object[])new Object[]{fullName}));
            }
            return tmpDevice;
        }
        throw new ObjectCreationException(Format.simple((String)"device '{}' not a device", (Object[])new Object[]{device}));
    }

    protected static <T> T toDeviceProvider(Class<T> clazz) throws ObjectCreationException {
        IDeviceProviderRegistry deviceProviderRegistry = DeviceProviderRegistry.get();
        for (IDeviceProvider<?> deviceProvider : deviceProviderRegistry.getDeviceProviders()) {
            if (!clazz.isInstance(deviceProvider)) continue;
            return (T)deviceProvider;
        }
        Object provider = ObjectTools.createObject(clazz, IDeviceProvider.class);
        ObjectTools.initObject((Object)provider);
        return (T)provider;
    }

    public static IDeviceProvider toDeviceProvider(Object value) throws ObjectCreationException {
        if (value == null) {
            return null;
        }
        if (value instanceof IDeviceProvider) {
            return (IDeviceProvider)value;
        }
        if (value instanceof Class) {
            return (IDeviceProvider)DeviceTools.toDeviceProvider((Class)value);
        }
        if (value instanceof String) {
            return DeviceTools.toDeviceProvider((String)value);
        }
        throw new IllegalArgumentException(Format.simple((String)"'{}' not a device provider", (Object[])new Object[]{value}));
    }

    protected static IDeviceProvider toDeviceProvider(String name) throws ObjectCreationException {
        IDeviceProviderRegistry deviceProviderRegistry = DeviceProviderRegistry.get();
        if (StringTools.isEmpty((String)name)) {
            return null;
        }
        IDeviceProvider provider = deviceProviderRegistry.lookupDeviceProvider(name);
        if (provider == null) {
            try {
                Class clazz = ClassTools.createClass((String)name, IDeviceProvider.class, null);
                return (IDeviceProvider)DeviceTools.toDeviceProvider(clazz);
            }
            catch (Exception e) {
                throw new ObjectCreationException(Format.simple((String)"device provider '{}' not found", (Object[])new Object[]{name}));
            }
        }
        return provider;
    }

    public static void validateId(String id) {
        if (!id.matches("[a-zA-Z0-9_-]+")) {
            throw new IllegalArgumentException(Format.simple((String)"device id '{}'contains illegal characters", (Object[])new Object[]{id}));
        }
    }
}

