/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.crypt.symmetric.common;

import de.intarsys.security.app.crypt.symmetric.common.ISymmetricCryptHandler;
import de.intarsys.security.app.crypt.symmetric.common.ISymmetricCryptHandlerRegistry;
import de.intarsys.security.app.crypt.symmetric.impl.AES128CBCCryptHandler;
import de.intarsys.security.app.crypt.symmetric.impl.AES128CFBCryptHandler;
import de.intarsys.security.app.crypt.symmetric.impl.AES128ECBCryptHandler;
import de.intarsys.security.app.crypt.symmetric.impl.AES128OFBCryptHandler;
import de.intarsys.security.app.crypt.symmetric.impl.AES192CBCCryptHandler;
import de.intarsys.security.app.crypt.symmetric.impl.AES192CFBCryptHandler;
import de.intarsys.security.app.crypt.symmetric.impl.AES192ECBCryptHandler;
import de.intarsys.security.app.crypt.symmetric.impl.AES192OFBCryptHandler;
import de.intarsys.security.app.crypt.symmetric.impl.AES256CBCCryptHandler;
import de.intarsys.security.app.crypt.symmetric.impl.AES256CFBCryptHandler;
import de.intarsys.security.app.crypt.symmetric.impl.AES256ECBCryptHandler;
import de.intarsys.security.app.crypt.symmetric.impl.AES256OFBCryptHandler;
import de.intarsys.security.app.crypt.symmetric.impl.RC240CBCCryptHandler;
import de.intarsys.security.app.crypt.symmetric.impl.ThreeDESCryptHandler;
import de.intarsys.security.device.DeviceTools;
import de.intarsys.security.device.IDeviceProvider;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.software.device.SoftwareDeviceProvider;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSymmetricCryptHandlerRegistry
implements ISymmetricCryptHandlerRegistry {
    private static final Logger Log = LoggerFactory.getLogger(DefaultSymmetricCryptHandlerRegistry.class);
    private List<ISymmetricCryptHandler> handlers = new ArrayList<ISymmetricCryptHandler>();
    private Map<String, ISymmetricCryptHandler> oidToHandler = new HashMap<String, ISymmetricCryptHandler>();
    private Map<String, ISymmetricCryptHandler> nameToHandler = new HashMap<String, ISymmetricCryptHandler>();

    public DefaultSymmetricCryptHandlerRegistry() throws ObjectCreationException {
        this.init();
    }

    @Override
    public List<ISymmetricCryptHandler> getHandlers() {
        return new ArrayList<ISymmetricCryptHandler>(this.handlers);
    }

    protected void init() throws ObjectCreationException {
        IDeviceProvider deviceProvider = DeviceTools.toDeviceProvider(SoftwareDeviceProvider.class);
        CommonDevice device = (CommonDevice)deviceProvider.listDevices(null).next();
        this.secureRegisterHandler(new AES128ECBCryptHandler(device));
        this.secureRegisterHandler(new AES128CBCCryptHandler(device));
        this.secureRegisterHandler(new AES128OFBCryptHandler(device));
        this.secureRegisterHandler(new AES128CFBCryptHandler(device));
        this.secureRegisterHandler(new AES192ECBCryptHandler(device));
        this.secureRegisterHandler(new AES192CBCCryptHandler(device));
        this.secureRegisterHandler(new AES192OFBCryptHandler(device));
        this.secureRegisterHandler(new AES192CFBCryptHandler(device));
        this.secureRegisterHandler(new AES256ECBCryptHandler(device));
        this.secureRegisterHandler(new AES256CBCCryptHandler(device));
        this.secureRegisterHandler(new AES256OFBCryptHandler(device));
        this.secureRegisterHandler(new AES256CFBCryptHandler(device));
        this.secureRegisterHandler(new ThreeDESCryptHandler(device));
        this.secureRegisterHandler(new RC240CBCCryptHandler(device));
    }

    @Override
    public ISymmetricCryptHandler lookupHandler(String name) {
        ISymmetricCryptHandler handler = this.oidToHandler.get(name);
        if (handler == null) {
            handler = this.nameToHandler.get(name);
        }
        return handler;
    }

    @Override
    public void registerHandler(ISymmetricCryptHandler handler) {
        this.handlers.add(handler);
        this.oidToHandler.put(handler.getAlgorithmOID(), handler);
        this.nameToHandler.put(handler.getAlgorithmName(), handler);
    }

    public void secureRegisterHandler(ISymmetricCryptHandler handler) {
        if (handler.isSupported()) {
            this.registerHandler(handler);
        } else {
            Log.info("Crypt algorithm '" + handler.getLabel() + "' not supported. Please install Java(TM) Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files.");
        }
    }

    @Override
    public void unregisterHandler(ISymmetricCryptHandler handler) {
        this.handlers.remove(handler);
        this.oidToHandler.remove(handler.getAlgorithmOID());
        this.nameToHandler.remove(handler.getAlgorithmName());
    }
}

