/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.st;

import de.intarsys.pdf.st.AbstractXRefWriter;
import de.intarsys.pdf.st.STXRefEntryCompressed;
import de.intarsys.pdf.st.STXRefSection;
import de.intarsys.pdf.st.STXRefSubsection;
import de.intarsys.pdf.st.XRefEntryVisitorException;
import de.intarsys.pdf.writer.COSWriter;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class XRefTrailerWriter
extends AbstractXRefWriter {
    public static final NumberFormat FORMAT_XREF_GENERATION = new DecimalFormat("00000");
    public static final NumberFormat FORMAT_XREF_OFFSET = new DecimalFormat("0000000000");
    protected static final byte[] TYPE_FREE = "f".getBytes();
    protected static final byte[] TYPE_OCCUPIED = "n".getBytes();
    protected static final byte[] XREF = "xref".getBytes();
    protected static final byte[] SPACE = " ".getBytes();
    protected static final byte[] CRLF = "\r\n".getBytes();
    protected static final byte[] EOL = StringTools.LS.getBytes();
    protected static final byte[] TRAILER = "trailer".getBytes();

    public XRefTrailerWriter(COSWriter cosWriter) {
        super(cosWriter);
    }

    @Override
    protected void finish(STXRefSection xRefSection) throws IOException {
        this.getCosWriter().write(TRAILER);
        this.getCosWriter().writeEOL();
        this.getCosWriter().writeObject(xRefSection.cosGetDict());
        super.finish(xRefSection);
    }

    @Override
    protected byte[] getTypeCompressed() {
        return TYPE_FREE;
    }

    @Override
    protected byte[] getTypeFree() {
        return TYPE_FREE;
    }

    @Override
    protected byte[] getTypeOccupied() {
        return TYPE_OCCUPIED;
    }

    @Override
    protected void initialize(STXRefSection xRefSection) throws IOException {
        super.initialize(xRefSection);
        this.setRandomAccess(this.getCosWriter().getRandomAccess());
        this.getRandomAccess().write(XREF);
        this.getRandomAccess().write(EOL);
    }

    @Override
    public void visitFromCompressed(STXRefEntryCompressed entry) throws XRefEntryVisitorException {
        try {
            this.write(entry.getObjectNumber(), 65535, this.getTypeFree());
        }
        catch (IOException e) {
            throw new XRefEntryVisitorException(e);
        }
    }

    @Override
    protected void visitFromSubsection(STXRefSubsection section) throws IOException {
        this.getRandomAccess().write(StringTools.toByteArray((String)Integer.toString(section.getStart())));
        this.getRandomAccess().write(SPACE);
        this.getRandomAccess().write(StringTools.toByteArray((String)Integer.toString(section.getSize())));
        this.getRandomAccess().write(EOL);
    }

    @Override
    protected void write(long col1, int col2, byte[] type) throws IOException {
        String stCol1 = FORMAT_XREF_OFFSET.format(col1);
        String stCol2 = FORMAT_XREF_GENERATION.format(col2);
        this.getRandomAccess().write(StringTools.toByteArray((String)stCol1));
        this.getRandomAccess().write(SPACE);
        this.getRandomAccess().write(StringTools.toByteArray((String)stCol2));
        this.getRandomAccess().write(SPACE);
        this.getRandomAccess().write(type);
        this.getRandomAccess().write(CRLF);
    }
}

