/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cds.CDSDate;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocumentElement;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSObjectProxy;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.parser.COSDocumentParser;
import de.intarsys.pdf.pd.PDAFSignatureField;
import de.intarsys.pdf.pd.PDBuildProperties;
import de.intarsys.pdf.pd.PDDocumentTimeStamp;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.pd.PDSignatureReference;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PDSignature
extends PDObject {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName CN_Type_Sig = COSName.constant("Sig");
    public static final COSName DK_Filter = COSName.constant("Filter");
    public static final COSName DK_SubFilter = COSName.constant("SubFilter");
    public static final COSName DK_Contents = COSName.constant("Contents");
    public static final COSName DK_Cert = COSName.constant("Cert");
    public static final COSName DK_ByteRange = COSName.constant("ByteRange");
    public static final COSName DK_Reference = COSName.constant("Reference");
    public static final COSName DK_Changes = COSName.constant("Changes");
    public static final COSName DK_Name = COSName.constant("Name");
    public static final COSName DK_M = COSName.constant("M");
    public static final COSName DK_Location = COSName.constant("Location");
    public static final COSName DK_Reason = COSName.constant("Reason");
    public static final COSName DK_ContactInfo = COSName.constant("ContactInfo");
    public static final COSName DK_R = COSName.constant("R");
    public static final COSName DK_V = COSName.constant("V");
    public static final COSName DK_Prop_Build = COSName.constant("Prop_Build");
    public static final COSName DK_Prop_AuthTime = COSName.constant("Prop_Auth_Time");
    public static final COSName DK_Prop_AuthType = COSName.constant("Prop_AuthType");
    private PDAFSignatureField acroFormField;
    private List cachedReferences;

    protected PDSignature(COSObject object) {
        super(object);
    }

    public COSArray cosGetByteRange() {
        return this.cosGetField(DK_ByteRange).asArray();
    }

    @Override
    protected COSName cosGetExpectedType() {
        return CN_Type_Sig;
    }

    public PDAFSignatureField getAcroFormField() {
        return this.acroFormField;
    }

    public PDBuildProperties getBuildProperties() {
        return (PDBuildProperties)PDBuildProperties.META.createFromCos(this.cosGetField(DK_Prop_Build));
    }

    public List getCert() {
        ArrayList<byte[]> result = null;
        COSObject cert = this.cosGetField(DK_Cert);
        if (!cert.isNull()) {
            result = new ArrayList<byte[]>();
            if (cert instanceof COSString) {
                result.add(((COSString)cert).byteValue());
                return result;
            }
            if (cert instanceof COSArray) {
                COSArray certArray = (COSArray)cert;
                Iterator<COSObject> i = certArray.iterator();
                while (i.hasNext()) {
                    COSString value = i.next().asString();
                    if (value == null) continue;
                    result.add(value.byteValue());
                }
            }
        }
        return result;
    }

    public String getContactInfo() {
        return this.getFieldString(DK_ContactInfo, null);
    }

    public byte[] getContentBytes() {
        COSString string;
        byte[] contentBytes = null;
        COSDocumentElement content = this.cosGetDict().basicGet(DK_Contents);
        if (content instanceof COSString) {
            contentBytes = this.getDoc().isEncrypted() ? this.getContentBytesPlain() : ((COSString)content).byteValue();
        } else if (content instanceof COSObjectProxy && (string = content.dereference().asString()) != null) {
            contentBytes = string.byteValue();
        }
        if (contentBytes == null) {
            contentBytes = new byte[]{};
        }
        return contentBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getContentBytesPlain() {
        IRandomAccess ra;
        block4: {
            byte[] byArray;
            COSArray cosByteRange = this.cosGetByteRange();
            if (cosByteRange.size() != 4) {
                return null;
            }
            ra = null;
            try {
                long startSigValue = cosByteRange.get(1).asInteger().longValue();
                ra = this.getDoc().getLocator().getRandomAccess();
                ra.seek(startSigValue);
                COSDocumentParser parser = new COSDocumentParser(null);
                Object object = parser.parseElement(ra);
                if (!(object instanceof COSString)) break block4;
                byArray = ((COSString)object).byteValue();
            }
            catch (Exception exception) {
                StreamTools.close(ra);
            }
            catch (Throwable throwable) {
                StreamTools.close(ra);
                throw throwable;
            }
            StreamTools.close((Closeable)ra);
            return byArray;
        }
        StreamTools.close((Closeable)ra);
        return null;
    }

    public CDSDate getDate() {
        return CDSDate.createFromCOS(this.cosGetField(DK_M).asString());
    }

    public COSName getFilter() {
        return this.cosGetField(DK_Filter).asName();
    }

    public String getLocation() {
        return this.getFieldString(DK_Location, null);
    }

    public String getName() {
        return this.getFieldString(DK_Name, null);
    }

    public String getReason() {
        return this.getFieldString(DK_Reason, null);
    }

    public List getSignatureReferences() {
        if (this.cachedReferences == null) {
            this.cachedReferences = this.getPDObjects(DK_Reference, PDSignatureReference.META, true);
        }
        return this.cachedReferences;
    }

    public COSName getSubFilter() {
        return this.cosGetField(DK_SubFilter).asName();
    }

    @Override
    public void invalidateCaches() {
        this.cachedReferences = null;
        super.invalidateCaches();
    }

    public void setAcroFormField(PDAFSignatureField acroFormField) {
        this.acroFormField = acroFormField;
    }

    public void setBuildProperties(PDBuildProperties buildProperties) {
        this.setFieldObject(DK_Prop_Build, buildProperties);
    }

    public void setCert(byte[] certificate) {
        if (certificate == null) {
            return;
        }
        COSString certString = COSString.createHex(certificate);
        this.cosSetField(DK_Cert, certString);
    }

    public void setCert(List certificates) {
        if (certificates == null || certificates.isEmpty()) {
            return;
        }
        if (certificates.size() == 1) {
            this.setCert((byte[])certificates.get(0));
            return;
        }
        COSArray certList = COSArray.create(certificates.size());
        Iterator i = certificates.iterator();
        while (i.hasNext()) {
            COSString certString = COSString.createHex((byte[])i.next());
            certList.add(certString);
        }
        this.cosSetField(DK_Cert, certList);
    }

    public void setContactInfo(String contactInfo) {
        this.setFieldString(DK_ContactInfo, contactInfo);
    }

    public void setDate(CDSDate date) {
        this.setFieldObject(DK_M, date);
    }

    public void setFilter(COSName filter) {
        this.cosSetField(DK_Filter, filter);
    }

    public void setLocation(String location) {
        this.setFieldString(DK_Location, location);
    }

    public void setName(String name) {
        this.setFieldString(DK_Name, name);
    }

    public void setReason(String reason) {
        this.setFieldString(DK_Reason, reason);
    }

    public void setSignatureReferences(List signatureReferences) {
        this.setPDObjects(DK_Reference, signatureReferences);
        this.cachedReferences = signatureReferences;
    }

    public void setSubFilter(COSName subfilter) {
        this.cosSetField(DK_SubFilter, subfilter);
    }

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new PDSignature(object);
        }

        @Override
        protected COSBasedObject.MetaClass doDetermineClass(COSObject object) {
            COSName type;
            if (object instanceof COSDictionary && PDDocumentTimeStamp.CN_Type_DocTimeStamp.equals(type = ((COSDictionary)object).get(PDObject.DK_Type).asName())) {
                return PDDocumentTimeStamp.META;
            }
            return META;
        }

        @Override
        public Class getRootClass() {
            return PDSignature.class;
        }
    }
}

