/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.filter.Filter;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.pd.PDVRI;

public class PDDSS
extends PDObject {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName CN_Type_DSS = COSName.constant("DSS");
    public static final COSName DK_Certs = COSName.constant("Certs");
    public static final COSName DK_OCSPs = COSName.constant("OCSPs");
    public static final COSName DK_CRLs = COSName.constant("CRLs");
    public static final COSName DK_VRI = COSName.constant("VRI");

    protected PDDSS(COSObject object) {
        super(object);
    }

    public void addCert(byte[] data) {
        this.addStream(DK_Certs, data);
    }

    public void addCRL(byte[] data) {
        this.addStream(DK_CRLs, data);
    }

    public void addOCSP(byte[] data) {
        this.addStream(DK_OCSPs, data);
    }

    protected void addStream(COSName key, byte[] data) {
        COSArray array = this.cosGetField(key).asArray();
        if (array == null) {
            array = COSArray.create();
            array.beIndirect();
            this.cosSetField(key, array);
        }
        COSStream stream = COSStream.create(null);
        stream.addFilter(Filter.CN_Filter_FlateDecode);
        stream.setDecodedBytes(data);
        array.add(stream);
    }

    protected byte[][] collectStreams(COSName key) {
        COSArray array = this.cosGetField(key).asArray();
        if (array == null) {
            return new byte[0][];
        }
        byte[][] result = new byte[array.size()][];
        for (int i = 0; i < array.size(); ++i) {
            COSStream stream = array.get(i).asStream();
            result[i] = stream.getDecodedBytes();
        }
        return result;
    }

    @Override
    protected COSName cosGetExpectedType() {
        return CN_Type_DSS;
    }

    public byte[][] getCerts() {
        return this.collectStreams(DK_Certs);
    }

    public byte[][] getCRLs() {
        return this.collectStreams(DK_CRLs);
    }

    public byte[][] getOCSPs() {
        return this.collectStreams(DK_OCSPs);
    }

    public PDVRI getVRI() {
        return (PDVRI)PDVRI.META.createFromCos(this.cosGetField(DK_VRI));
    }

    public void setVRI(PDVRI vri) {
        this.setFieldObject(DK_VRI, vri);
    }

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new PDDSS(object);
        }
    }
}

