/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.cwt.font.afm.AFM;
import de.intarsys.cwt.font.afm.AFMChar;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.encoding.Encoding;
import de.intarsys.pdf.encoding.GlyphNameMap;

public class AFMEncoding
extends Encoding {
    private final AFM afm;

    public AFMEncoding(AFM afm) {
        this.afm = afm;
    }

    @Override
    public COSObject cosGetObject() {
        return null;
    }

    public AFM getAfm() {
        return this.afm;
    }

    @Override
    public int getDecoded(int codepoint) {
        String glyphName = this.getGlyphName(codepoint);
        if (glyphName == null) {
            return -1;
        }
        return GlyphNameMap.Standard.getUnicode(glyphName);
    }

    @Override
    public int getEncoded(int character) {
        String glyphName = GlyphNameMap.Standard.getGlyphName(character);
        return this.getEncoded(glyphName);
    }

    @Override
    public int getEncoded(String name) {
        AFMChar c = this.getAfm().getCharByName(name);
        if (c != null) {
            return c.getCode();
        }
        return -1;
    }

    @Override
    public String getGlyphName(int codePoint) {
        AFMChar c = this.getAfm().getCharByCode(codePoint);
        if (c != null) {
            return c.getName();
        }
        return ".notdef";
    }

    @Override
    public String getName() {
        return "AFMEncoding";
    }
}

