/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.filter;

import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.filter.Prediction;

public class TIFFPrediction
extends Prediction {
    public TIFFPrediction(COSDictionary options) {
        super(options);
    }

    @Override
    protected void decodeRow(byte[] source, int sourceOffset, byte[] result, int resultOffset) {
        if (this.getBitsPerComponent() != 8) {
            return;
        }
        int colors = this.getColors();
        int columns = this.getColumns();
        for (int index = 0; index < colors; ++index) {
            result[resultOffset + index] = source[sourceOffset + index];
        }
        for (int byteIndex = 1; byteIndex < columns; ++byteIndex) {
            for (int colorIndex = 0; colorIndex < colors; ++colorIndex) {
                result[resultOffset + byteIndex * colors + colorIndex] = (byte)(result[resultOffset + (byteIndex - 1) * colors + colorIndex] + source[sourceOffset + byteIndex * colors + colorIndex]);
            }
        }
    }

    public int getRowSize() {
        return this.getColumns() * this.getColors();
    }
}

