/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.filter;

import de.intarsys.tools.hex.HexTools;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class ASCIIHexInputStream
extends FilterInputStream {
    private boolean eod = false;

    public static boolean isWhitespace(int i) {
        return i == 32 || i == 9 || i == 13 || i == 10 || i == 12;
    }

    public ASCIIHexInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int available() throws IOException {
        throw new IOException("method not supported");
    }

    protected int basicRead() throws IOException {
        if (this.eod) {
            return -1;
        }
        int next = this.in.read();
        while (ASCIIHexInputStream.isWhitespace(next)) {
            next = this.in.read();
        }
        if (next == -1 || next == 62) {
            this.eod = true;
            return -1;
        }
        return next;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        int digit1 = 0;
        int digit2 = 0;
        int next = this.basicRead();
        if (next == -1) {
            return -1;
        }
        digit1 = HexTools.hexDigitToInt((char)((char)next));
        if (digit1 == -1) {
            throw new IOException("<" + next + "> not a valid hex char");
        }
        next = this.basicRead();
        if (next != -1 && (digit2 = HexTools.hexDigitToInt((char)((char)next))) == -1) {
            throw new IOException("<" + next + "> not a valid hex char");
        }
        return (digit1 << 4) + digit2;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i;
        Objects.requireNonNull(b, "bytes cannot be null");
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        b[off] = (byte)c;
        for (i = 1; i < len && (c = this.read()) != -1; ++i) {
            b[off + i] = (byte)c;
        }
        return i;
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("method not supported");
    }

    @Override
    public long skip(long n) throws IOException {
        throw new IOException("method not supported");
    }
}

