/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.crypt;

import de.intarsys.pdf.crypt.COSSecurityException;
import de.intarsys.pdf.crypt.IAuthenticationHandler;
import de.intarsys.pdf.crypt.IPasswordProvider;
import de.intarsys.pdf.crypt.ISecurityHandler;
import de.intarsys.pdf.crypt.PasswordProvider;
import de.intarsys.pdf.crypt.StandardSecurityHandler;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.tools.string.CharacterTools;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class StandardAuthenticationHandler
implements IAuthenticationHandler {
    private IPasswordProvider passwordProvider;
    private int retries = 3;
    private boolean useDefaultAuthentication = true;

    @Override
    public void authenticate(ISecurityHandler securityHandler) throws COSSecurityException {
        if (!(securityHandler instanceof StandardSecurityHandler)) {
            throw new COSSecurityException("security handler not supported");
        }
        StandardSecurityHandler standardSecurityHandler = (StandardSecurityHandler)securityHandler;
        if (this.isUseDefaultAuthentication() && standardSecurityHandler.authenticateUser(null)) {
            return;
        }
        STDocument stDocument = securityHandler.stGetDoc();
        char[] password = PasswordProvider.getPassword(stDocument);
        if (password != null) {
            if (!this.authenticate(standardSecurityHandler, password)) {
                throw new COSSecurityException("wrong password");
            }
        } else {
            IPasswordProvider passwordProvider = PasswordProvider.getPasswordProvider(stDocument);
            if (passwordProvider == null) {
                passwordProvider = this.getPasswordProvider();
            }
            if (passwordProvider == null) {
                throw new COSSecurityException("password missing");
            }
            this.authenticate(standardSecurityHandler, passwordProvider);
        }
    }

    protected boolean authenticate(StandardSecurityHandler standardSecurityHandler, char[] password) throws COSSecurityException {
        byte[] bytes;
        Charset encoding = StandardCharsets.ISO_8859_1;
        if (standardSecurityHandler.getRevision() == 5 || standardSecurityHandler.getRevision() == 6) {
            encoding = StandardCharsets.UTF_8;
        }
        if (standardSecurityHandler.authenticateOwner(bytes = CharacterTools.toByteArray((char[])password, (Charset)encoding))) {
            return true;
        }
        return standardSecurityHandler.authenticateUser(bytes);
    }

    protected void authenticate(StandardSecurityHandler standardSecurityHandler, IPasswordProvider passwordProvider) throws COSSecurityException {
        char[] password = null;
        try {
            do {
                if ((password = passwordProvider.getPassword()) == null) {
                    throw new COSSecurityException("password missing");
                }
                if (this.authenticate(standardSecurityHandler, password)) {
                    return;
                }
                --this.retries;
            } while (this.getRetries() > 0);
            throw new COSSecurityException("wrong password");
        }
        finally {
            CharacterTools.clear((char[])password);
        }
    }

    public IPasswordProvider getPasswordProvider() {
        if (this.passwordProvider == null) {
            return PasswordProvider.get();
        }
        return this.passwordProvider;
    }

    public int getRetries() {
        return this.retries;
    }

    public boolean isUseDefaultAuthentication() {
        return this.useDefaultAuthentication;
    }

    public void setPasswordProvider(IPasswordProvider passwordProvider) {
        this.passwordProvider = passwordProvider;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setUseDefaultAuthentication(boolean useDefaultAuthentication) {
        this.useDefaultAuthentication = useDefaultAuthentication;
    }
}

