/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.crypt;

import de.intarsys.pdf.crypt.IPasswordProvider;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.tools.component.Singleton;
import de.intarsys.tools.string.CharacterTools;
import java.util.Map;

@Singleton
public class PasswordProvider {
    public static final String ATTR_PASSWORD = "password";
    public static final String ATTR_PASSWORDPROVIDER = "passwordProvider";
    private static final ThreadLocal<IPasswordProvider> ACTIVE = new ThreadLocal();
    private static IPasswordProvider Unique;

    public static IPasswordProvider get() {
        IPasswordProvider result = PasswordProvider.getThreadLocal();
        if (result == null) {
            return Unique;
        }
        return result;
    }

    public static char[] getPassword(STDocument doc) {
        Object password = doc.getAttribute(ATTR_PASSWORD);
        if (password instanceof String) {
            return ((String)password).toCharArray();
        }
        if (password instanceof char[]) {
            return (char[])password;
        }
        if (password instanceof byte[]) {
            return CharacterTools.toCharArray((byte[])((byte[])password));
        }
        return null;
    }

    public static IPasswordProvider getPasswordProvider(STDocument doc) {
        Object passwordProvider = doc.getAttribute(ATTR_PASSWORDPROVIDER);
        if (passwordProvider instanceof IPasswordProvider) {
            return (IPasswordProvider)passwordProvider;
        }
        return null;
    }

    private static IPasswordProvider getThreadLocal() {
        return ACTIVE.get();
    }

    public static void set(IPasswordProvider unique) {
        Unique = unique;
    }

    public static void setPassword(Map options, char[] password) {
        options.put(ATTR_PASSWORD, password);
    }

    public static void setPasswordProvider(Map options, IPasswordProvider passwordProvider) {
        options.put(ATTR_PASSWORDPROVIDER, passwordProvider);
    }

    public static void setThreadLocal(IPasswordProvider passwordProvider) {
        if (passwordProvider == null) {
            ACTIVE.remove();
        } else {
            ACTIVE.set(passwordProvider);
        }
    }

    private PasswordProvider() {
    }
}

