/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.crypt;

import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.crypt.AccessPermissionChain;
import de.intarsys.pdf.crypt.AccessPermissionsDocMDP;
import de.intarsys.pdf.crypt.AccessPermissionsLocked;
import de.intarsys.pdf.crypt.IAccessPermissions;
import de.intarsys.pdf.pd.PDAFSignatureField;
import de.intarsys.pdf.pd.PDAcroForm;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDSignature;
import de.intarsys.pdf.pd.PDSignatureReference;
import de.intarsys.pdf.pd.PDTransformMethod;
import de.intarsys.pdf.pd.PDTransformMethodDocMDP;
import de.intarsys.pdf.pd.PDTransformMethodFieldMDP;
import de.intarsys.pdf.pd.PDTransformParams;
import de.intarsys.tools.function.Predicates;
import java.util.List;
import java.util.stream.Stream;

public class AccessPermissionsTools {
    public static IAccessPermissions createPermissions(PDDocument doc) {
        AccessPermissionChain chain = new AccessPermissionChain();
        chain.add(doc.cosGetDoc().getAccessPermissions());
        PDSignatureReference reference = AccessPermissionsTools.findDocMDPReference(doc);
        if (reference != null) {
            chain.add(new AccessPermissionsDocMDP(reference.getTransformParams()));
        }
        Stream<PDTransformParams> signatureLocks = AccessPermissionsTools.findEffectiveSignatureTransformParams(doc);
        signatureLocks.filter(p -> p.isActionAll()).findAny().ifPresent(p -> chain.add(AccessPermissionsLocked.get()));
        return chain;
    }

    public static PDSignatureReference findDocMDPReference(PDDocument doc) {
        COSObject cosDocMDPSig;
        COSDictionary perms = doc.cosGetPermissionsDict();
        if (perms != null && !(cosDocMDPSig = perms.get(PDTransformMethod.DK_DocMDP)).isNull()) {
            PDSignature sig = (PDSignature)PDSignature.META.createFromCos(cosDocMDPSig);
            List references = sig.getSignatureReferences();
            for (PDSignatureReference reference : references) {
                if (reference.getTransformMethod() != PDTransformMethodDocMDP.SINGLETON) continue;
                return reference;
            }
        }
        return null;
    }

    public static Stream<PDTransformParams> findEffectiveSignatureTransformParams(PDDocument doc) {
        return AccessPermissionsTools.findFieldMDPReferences(doc).map(PDSignatureReference::getTransformParams);
    }

    public static Stream<PDSignatureReference> findFieldMDPReferences(PDDocument doc) {
        PDAcroForm acroForm = doc.getAcroForm();
        if (acroForm == null) {
            return Stream.empty();
        }
        List leafFields = acroForm.collectLeafFields();
        return leafFields.stream().filter(PDAcroFormField::isTypeSig).map(PDAFSignatureField.class::cast).map(PDAFSignatureField::getSignature).filter(Predicates.isNotNull()).map(s -> s.getSignatureReferences()).filter(Predicates.isNotNull()).flatMap(sr -> sr.stream()).map(PDSignatureReference.class::cast).filter(r -> ((PDSignatureReference)r).getTransformMethod() == PDTransformMethodFieldMDP.SINGLETON);
    }

    private AccessPermissionsTools() {
    }
}

