/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBoolean;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSDocumentElement;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.cos.ICOSContainer;
import de.intarsys.pdf.cos.ICOSObjectListener;
import de.intarsys.tools.component.ISaveStateSupport;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class COSObject
extends COSDocumentElement
implements ISaveStateSupport,
Iterable<COSObject> {
    public static final ICOSContainer CONSTANT_CONTAINER = new ICOSContainer(){

        @Override
        public ICOSContainer associate(ICOSContainer newContainer, COSObject object) {
            throw new IllegalStateException("constants can not be contained");
        }

        @Override
        public COSDocumentElement containable(COSObject object) {
            return object.copyDeep().containable();
        }

        @Override
        public ICOSContainer disassociate(ICOSContainer oldContainer, COSObject object) {
            throw new IllegalStateException("constants can not be contained");
        }

        @Override
        public COSDocument getDoc() {
            return null;
        }

        @Override
        public void harden(COSObject object) {
        }

        @Override
        public boolean isStale() {
            return false;
        }

        @Override
        public int referenceCount() {
            return 0;
        }

        @Override
        public COSObject referenceDirect(COSIndirectObject ref) {
            throw new IllegalStateException("transition not possible");
        }

        @Override
        public COSIndirectObject referenceIndirect(COSObject object) {
            throw new IllegalStateException("constants cannot be indirect");
        }

        @Override
        public void register(COSDocumentElement object) {
        }

        @Override
        public ICOSContainer restoreStateContainer(ICOSContainer container) {
            return container;
        }

        @Override
        public ICOSContainer saveStateContainer() {
            return this;
        }

        @Override
        public void soften(COSObject object) {
        }

        @Override
        public void willChange(COSObject object) {
        }
    };
    public static final ICOSContainer NULL_CONTAINER = new ICOSContainer(){

        @Override
        public ICOSContainer associate(ICOSContainer newContainer, COSObject object) {
            object.basicSetContainer(newContainer);
            newContainer.register(object);
            return newContainer;
        }

        @Override
        public COSDocumentElement containable(COSObject object) {
            return object;
        }

        @Override
        public ICOSContainer disassociate(ICOSContainer oldContainer, COSObject object) {
            throw new IllegalStateException("association inconsistent");
        }

        @Override
        public COSDocument getDoc() {
            return null;
        }

        @Override
        public void harden(COSObject object) {
        }

        @Override
        public boolean isStale() {
            return false;
        }

        @Override
        public int referenceCount() {
            return 0;
        }

        @Override
        public COSObject referenceDirect(COSIndirectObject ref) {
            throw new IllegalStateException("transition not possible");
        }

        @Override
        public COSIndirectObject referenceIndirect(COSObject object) {
            return COSIndirectObject.create(object);
        }

        @Override
        public void register(COSDocumentElement object) {
        }

        @Override
        public ICOSContainer restoreStateContainer(ICOSContainer container) {
            return container;
        }

        @Override
        public ICOSContainer saveStateContainer() {
            return this;
        }

        @Override
        public void soften(COSObject object) {
        }

        @Override
        public void willChange(COSObject object) {
        }
    };
    public static final Object SLOT_CONTAINER = new Object();
    protected ICOSContainer container = NULL_CONTAINER;

    protected COSObject() {
    }

    @Override
    protected ICOSContainer addContainer(ICOSContainer newContainer) {
        return this.container.associate(newContainer, this);
    }

    public abstract void addObjectListener(ICOSObjectListener var1);

    public COSArray asArray() {
        return null;
    }

    public COSBoolean asBoolean() {
        return null;
    }

    public COSDictionary asDictionary() {
        return null;
    }

    public COSFixed asFixed() {
        return null;
    }

    public COSInteger asInteger() {
        return null;
    }

    public COSName asName() {
        return null;
    }

    public COSNull asNull() {
        return null;
    }

    public COSNumber asNumber() {
        return null;
    }

    public COSStream asStream() {
        return null;
    }

    public COSString asString() {
        return null;
    }

    public abstract Iterator<COSDocumentElement> basicIterator();

    protected void basicSetContainer(ICOSContainer newContainer) {
        this.container = newContainer;
    }

    protected abstract String basicToString();

    public COSObject beConstant() {
        this.container = CONSTANT_CONTAINER;
        return this;
    }

    public COSIndirectObject beIndirect() {
        return this.container.referenceIndirect(this);
    }

    @Override
    public COSDocumentElement containable() {
        return this.container.containable(this);
    }

    protected abstract COSObject copyBasic();

    public abstract COSObject copyDeep();

    @Override
    public abstract COSObject copyDeep(Map var1);

    public final COSObject copyOptional() {
        if (this.isIndirect()) {
            return this;
        }
        return this.copyShallow();
    }

    public COSObject copyShallow() {
        COSObject result = this.copyBasic();
        if (this.isIndirect()) {
            result.beIndirect();
        }
        return result;
    }

    @Override
    protected COSDocumentElement copyShallowNested() {
        return this.copyShallow();
    }

    public final COSObject copySubGraph() {
        return this.copySubGraph(new HashMap());
    }

    protected COSObject copySubGraph(Map copied) {
        COSObject result = this.copyBasic();
        if (this.isIndirect()) {
            result.beIndirect();
            copied.put(this.getIndirectObject(), result);
        }
        return result;
    }

    @Override
    public COSObject dereference() {
        return this;
    }

    public ICOSContainer getContainer() {
        return this.container;
    }

    @Override
    public COSDocument getDoc() {
        return this.container.getDoc();
    }

    public COSIndirectObject getIndirectObject() {
        if (this.container instanceof COSIndirectObject) {
            return (COSIndirectObject)this.container;
        }
        return null;
    }

    public boolean getValueBoolean(boolean defaultValue) {
        COSBoolean tempCos = this.asBoolean();
        if (tempCos == null) {
            return defaultValue;
        }
        return tempCos.booleanValue();
    }

    public byte[] getValueBytes(byte[] defaultValue) {
        COSObject tempCos = this.asString();
        if (tempCos != null) {
            return tempCos.byteValue();
        }
        tempCos = this.asName();
        if (tempCos != null) {
            return ((COSName)tempCos).byteValue();
        }
        tempCos = this.asStream();
        if (tempCos != null) {
            return ((COSStream)tempCos).getDecodedBytes();
        }
        return defaultValue;
    }

    public float getValueFloat(float defaultValue) {
        COSNumber tempCos = this.asNumber();
        if (tempCos == null) {
            return defaultValue;
        }
        return tempCos.floatValue();
    }

    public int getValueInteger(int defaultValue) {
        COSNumber tempCos = this.asNumber();
        if (tempCos == null) {
            return defaultValue;
        }
        return tempCos.intValue();
    }

    public String getValueString(String defaultValue) {
        COSObject tempCos = this.asString();
        if (tempCos != null) {
            return tempCos.stringValue();
        }
        tempCos = this.asName();
        if (tempCos != null) {
            return tempCos.stringValue();
        }
        tempCos = this.asStream();
        if (tempCos != null) {
            return tempCos.stringValue();
        }
        return defaultValue;
    }

    public void harden() {
        this.container.harden(this);
    }

    protected boolean hasNavigationPathTo(COSObject other) {
        return false;
    }

    public boolean isDangling() {
        return this.container.referenceCount() == 0;
    }

    public boolean isIndirect() {
        return this.container instanceof COSIndirectObject;
    }

    public boolean isNull() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public abstract boolean isObjectListenerAvailable();

    public abstract boolean isPrimitive();

    @Override
    public boolean isStale() {
        return this.container.isStale();
    }

    @Override
    public boolean isSwapped() {
        return this.isIndirect() && this.getIndirectObject().isSwapped();
    }

    public boolean mayBeSwapped() {
        return false;
    }

    @Override
    protected ICOSContainer removeContainer(ICOSContainer oldContainer) {
        return this.container.disassociate(oldContainer, this);
    }

    public abstract void removeObjectListener(ICOSObjectListener var1);

    public void restoreState(Object saveState) {
        this.container = this.container.restoreStateContainer(((COSObject)saveState).container);
    }

    public void soften() {
        this.container.soften(this);
    }

    public String stringValue() {
        return this.basicToString();
    }

    public String toString() {
        return this.basicToString();
    }

    protected abstract void triggerChanged(Object var1, Object var2, Object var3);
}

