/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSPrimitiveObject;
import de.intarsys.pdf.cos.COSVisitorException;
import de.intarsys.pdf.cos.ICOSObjectVisitor;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class COSName
extends COSPrimitiveObject {
    private String string;
    private final byte[] bytes;
    private int hash;

    public static COSName constant(String name) {
        return (COSName)COSName.create(name).beConstant();
    }

    public static COSName constantUTF8(String name) {
        return (COSName)COSName.createUTF8(name).beConstant();
    }

    public static COSName create(byte[] bytes) {
        return new COSName(bytes, true);
    }

    public static COSName create(String name) {
        return new COSName(name.getBytes(), true);
    }

    public static COSName createUTF8(String name) {
        return new COSName(name.getBytes(StandardCharsets.UTF_8), true);
    }

    protected COSName(byte[] newName) {
        this.bytes = newName;
    }

    protected COSName(byte[] newName, boolean computeHash) {
        this.bytes = newName;
        this.computeHash();
    }

    @Override
    public Object accept(ICOSObjectVisitor visitor) throws COSVisitorException {
        return visitor.visitFromName(this);
    }

    @Override
    public COSName asName() {
        return this;
    }

    @Override
    protected String basicToString() {
        return "/" + this.stringValue();
    }

    public byte[] byteValue() {
        return this.bytes;
    }

    private void computeHash() {
        int h = 0;
        for (int i = 0; i < this.bytes.length; ++i) {
            h = 31 * h + this.bytes[i];
        }
        this.hash = h;
    }

    @Override
    protected COSObject copyBasic() {
        COSName result = new COSName(this.bytes);
        result.string = this.string;
        result.hash = this.hash;
        return result;
    }

    protected String decode() {
        boolean utf8 = false;
        for (int i = 0; i < this.bytes.length; ++i) {
            int test;
            if (this.bytes[i] >= 0 || (test = this.bytes[i] & 0xF8) != 192 && test != 224 && test != 240) continue;
            if (i + 1 == this.bytes.length || (this.bytes[++i] & 0xC0) != 128) break;
            utf8 = true;
            break;
        }
        if (utf8) {
            return new String(this.bytes, StandardCharsets.UTF_8);
        }
        return new String(this.bytes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof COSName)) {
            return false;
        }
        return Arrays.equals(this.bytes, ((COSName)o).byteValue());
    }

    public int hashCode() {
        return this.hash;
    }

    @Override
    public void restoreState(Object object) {
        super.restoreState(object);
        COSName name = (COSName)object;
        this.string = name.string;
        this.hash = name.hash;
    }

    public Object saveState() {
        COSName result = new COSName(this.bytes);
        result.string = this.string;
        result.hash = this.hash;
        result.container = this.container.saveStateContainer();
        return result;
    }

    @Override
    public String stringValue() {
        if (this.string == null) {
            this.string = this.decode();
        }
        return this.string;
    }
}

