/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.observer;

import de.intarsys.pdf.app.observer.COSAbstractWatchdog;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSPrimitiveObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.cos.ICOSDocumentListener;
import de.intarsys.pdf.cos.ICOSObjectListener;
import java.util.ArrayList;
import java.util.List;

public class COSAspectWatchdog
extends COSAbstractWatchdog
implements ICOSObjectListener,
ICOSDocumentListener {
    private COSAbstractWatchdog parent;
    private Object slot;
    private ICOSObjectListener listener;
    private COSDictionary trailerDict;

    public COSAspectWatchdog(Object slot, ICOSObjectListener listener) {
        this.slot = slot;
        this.listener = listener;
    }

    protected void armDocument(COSDocument doc) {
        doc.addDocumentListener(this);
        this.trailerDict = doc.stGetDoc().cosGetTrailer();
        this.armObject(this.trailerDict);
    }

    protected void armList(List list) {
        for (COSObject element : list) {
            element.addObjectListener(this);
        }
    }

    protected void armObject(COSObject object) {
        object.addObjectListener(this);
    }

    protected void basicChanged(COSObject pObject, Object pSlot, Object oldValue, Object newValue) {
        if (this.listener != null) {
            this.listener.changed(pObject, pSlot, oldValue, newValue);
        }
    }

    @Override
    protected void basicStart() {
        super.basicStart();
        Object tempWatched = this.getWatched();
        if (tempWatched instanceof COSObject) {
            this.armObject((COSObject)tempWatched);
        } else if (tempWatched instanceof COSDocument) {
            this.armDocument((COSDocument)tempWatched);
        } else {
            this.armList((List)tempWatched);
        }
    }

    @Override
    protected void basicStop() {
        Object tempWatched = this.getWatched();
        if (tempWatched instanceof COSObject) {
            this.disarmObject((COSObject)tempWatched);
        } else if (tempWatched instanceof COSDocument) {
            this.disarmDocument((COSDocument)tempWatched);
        } else {
            this.disarmList((List)tempWatched);
        }
        super.basicStop();
    }

    @Override
    public void changed(COSDocument document, Object slot, Object oldValue, Object newValue) {
        if (slot == COSDocument.SLOT_ALL || slot == COSDocument.SLOT_TRAILER) {
            this.stopChildren();
            if (this.trailerDict != null) {
                this.disarmObject(this.trailerDict);
            }
            this.trailerDict = document.stGetDoc().cosGetTrailer();
            this.armObject(this.trailerDict);
            this.startChildren();
        }
    }

    @Override
    public void changed(COSObject pObject, Object pSlot, Object oldValue, Object newValue) {
        if (this.isTriggered(pObject, pSlot, oldValue, newValue)) {
            this.stopChildren();
            this.basicChanged(pObject, pSlot, oldValue, newValue);
            this.startChildren();
        }
    }

    protected void disarmDocument(COSDocument doc) {
        doc.removeDocumentListener(this);
        if (this.trailerDict != null) {
            this.disarmObject(this.trailerDict);
            this.trailerDict = null;
        }
    }

    protected void disarmList(List list) {
        for (COSObject element : list) {
            element.removeObjectListener(this);
        }
    }

    protected void disarmObject(COSObject object) {
        object.removeObjectListener(this);
    }

    protected Object expand(COSObject object) {
        ArrayList<COSObject> result = new ArrayList<COSObject>();
        for (COSObject element : object) {
            result.add(element);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    @Override
    protected Object getChildObject() {
        Object tempWatched = this.getWatched();
        if (tempWatched instanceof COSObject) {
            return this.getMember((COSObject)tempWatched);
        }
        if (tempWatched instanceof COSDocument) {
            return this.getMember((COSDocument)tempWatched);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (COSObject element : (List)tempWatched) {
            Object member = this.getMember(element);
            if (member == null || member instanceof COSPrimitiveObject) continue;
            if (member instanceof List) {
                result.addAll((List)member);
                continue;
            }
            result.add(member);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    protected Object getMember(COSDocument doc) {
        COSDictionary tempDict = doc.stGetDoc().cosGetTrailer();
        if (this.getSlot() == null) {
            return this.expand(tempDict);
        }
        if (this.getSlot() instanceof COSName) {
            return tempDict.get((COSName)this.getSlot());
        }
        return null;
    }

    protected Object getMember(COSObject object) {
        if (this.getSlot() == null) {
            return this.expand(object);
        }
        if (object instanceof COSArray) {
            if (this.getSlot() instanceof Number) {
                return ((COSArray)object).get(((Number)this.getSlot()).intValue());
            }
        } else if (object instanceof COSDictionary) {
            if (this.getSlot() instanceof COSName) {
                return ((COSDictionary)object).get((COSName)this.getSlot());
            }
        } else if (object instanceof COSStream && this.getSlot() instanceof COSName) {
            return ((COSStream)object).getDict().get((COSName)this.getSlot());
        }
        return null;
    }

    protected COSAbstractWatchdog getParent() {
        return this.parent;
    }

    public Object getSlot() {
        return this.slot;
    }

    protected boolean isTriggered(COSObject pObject, Object pSlot, Object oldValue, Object newValue) {
        return pSlot == null || this.slot == null || pSlot.equals(this.slot);
    }

    protected void restartParent() {
        this.stop();
        this.start();
    }

    protected void setListener(ICOSObjectListener listener) {
        this.listener = listener;
    }

    protected void setParent(COSAbstractWatchdog parent) {
        this.parent = parent;
    }

    protected void setSlot(Object slot) {
        this.slot = slot;
    }
}

