/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.license;

import de.intarsys.tools.collection.ByteArrayTools;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.license.LicenseException;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.tlv.common.SimpleElement;
import de.intarsys.tools.tlv.common.SimpleInputStream;
import de.intarsys.tools.tlv.common.TlvElement;
import de.intarsys.tools.tlv.common.TlvTemplate;
import java.io.IOException;
import java.security.Key;

public class LicenseToken {
    private int version;
    private long timestamp;

    public static LicenseToken createFromBase64(String value) throws LicenseException {
        if (StringTools.isEmpty((String)value)) {
            return null;
        }
        try {
            byte[] bytes = Base64.decode((String)value);
            LicenseToken token = new LicenseToken();
            token.parse(bytes);
            return token;
        }
        catch (LicenseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LicenseException("error parsing license token", e);
        }
    }

    public static LicenseToken createNew() throws LicenseException {
        LicenseToken token = new LicenseToken();
        token.setVersion(0);
        token.setTimestamp(System.currentTimeMillis());
        return token;
    }

    protected LicenseToken() {
    }

    public byte[] decrypt(Key key) {
        return this.toByteArray();
    }

    public byte[] encrypt(Key key) {
        return this.toByteArray();
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final int getVersion() {
        return this.version;
    }

    protected void parse(byte[] bytes) throws LicenseException {
        block14: {
            try (SimpleInputStream is = new SimpleInputStream(bytes, 0, bytes.length);){
                TlvElement element = is.readElement();
                if (element == null) {
                    throw new LicenseException("empty license token");
                }
                if (element.getIdentifier() == 0) {
                    TlvTemplate template = element.getTemplate();
                    for (TlvElement child : template) {
                        int id = child.getIdentifier();
                        if (id == 1) {
                            this.setVersion(element.getValue()[0]);
                        } else if (id == 2) {
                            this.setTimestamp(ByteArrayTools.toLittleEndianLong((byte[])child.getValue(), (int)0, (int)8));
                        } else {
                            throw new LicenseException("unknown token type " + id);
                        }
                        element = is.readElement();
                    }
                    break block14;
                }
                throw new LicenseException("unknown token type " + element.getIdentifier());
            }
            catch (IOException e) {
                throw new LicenseException("error parsing license token", e);
            }
        }
    }

    public final void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public final void setVersion(int version) {
        this.version = version;
    }

    protected byte[] toByteArray() {
        TlvTemplate template = new TlvTemplate();
        template.addElement((TlvElement)new SimpleElement(1, new byte[]{(byte)this.getVersion()}));
        template.addElement((TlvElement)new SimpleElement(2, ByteArrayTools.toBytesLittleEndian((long)this.getTimestamp(), (int)8)));
        SimpleElement element = new SimpleElement(0, template.getEncoded());
        return element.getEncoded();
    }
}

