/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.license;

import de.intarsys.tools.file.FileLoader;
import de.intarsys.tools.license.License;
import de.intarsys.tools.license.LicenseEnvironment;
import de.intarsys.tools.license.LicenseException;
import de.intarsys.tools.license.LicenseRepository;
import de.intarsys.tools.license.LicenseTools;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorWalker;
import de.intarsys.tools.locator.SchemeBasedLocatorFactory;
import de.intarsys.tools.string.StringTools;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseLoader {
    private static final Logger Log = LoggerFactory.getLogger(LicenseLoader.class);
    private final FileLoader loader = new FileLoader(){

        protected boolean basicLoadFile(File file, boolean readOnly, String path) {
            if (file.getName().startsWith(".")) {
                Log.debug("ignore license file '{}'", (Object)file);
                return true;
            }
            FileLocator locator = new FileLocator(file);
            LicenseLoader.this.basicLoadLocator((ILocator)locator);
            return true;
        }
    };
    private File path;
    private String location;
    private LicenseRepository licenseRepository = LicenseEnvironment.get().getLicenseRepositoryRoot();

    protected void basicLoadLocator(ILocator locator) {
        try {
            List<License> licenses = LicenseTools.loadLicense(locator);
            licenses.stream().forEach(license -> this.getLicenseRepository().addLicense((License)license));
            Log.info("loaded {} licenses from '{}'", (Object)licenses.size(), (Object)locator.getPath());
        }
        catch (LicenseException e) {
            Log.error("error loading license '" + locator + "'", (Throwable)e);
        }
    }

    public LicenseRepository getLicenseRepository() {
        return this.licenseRepository;
    }

    protected FileLoader getLoader() {
        return this.loader;
    }

    public String getLocation() {
        return this.location;
    }

    public File getPath() {
        return this.path;
    }

    @PostConstruct
    public void install() {
        if (!StringTools.isEmpty((String)this.getLocation())) {
            try {
                Log.info("loading licenses from '{}'", (Object)this.getLocation());
                SchemeBasedLocatorFactory factory = SchemeBasedLocatorFactory.createDefault();
                ILocator locator = factory.createLocator(this.getLocation());
                LocatorWalker walker = new LocatorWalker(locator);
                walker.forEach(node -> this.basicLoadLocator(node.locator));
            }
            catch (IOException le) {
                Log.error("error loading license", (Throwable)le);
            }
            return;
        }
        if (this.getPath() != null) {
            try {
                Log.info("loading licenses from '{}', 'licenses' directory", (Object)this.getPath());
                this.getLoader().load(this.getPath(), "licenses", false, false);
            }
            catch (IOException le) {
                Log.error("error loading license", (Throwable)le);
            }
            return;
        }
        throw new IllegalArgumentException("no license location defined");
    }

    public void setLicenseRepository(LicenseRepository licenseRepository) {
        this.licenseRepository = licenseRepository;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setPath(File path) {
        this.path = path;
    }
}

