/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.processor.document.standard;

import de.intarsys.document.common.DocumentTools;
import de.intarsys.document.model.DocumentEnvironment;
import de.intarsys.document.model.IDocumentType;
import de.intarsys.processor.common.CommonProcessor;
import de.intarsys.processor.common.CommonProcessorFactory;
import de.intarsys.processor.document.standard.LoadSelector;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.BasicLocatorFactory;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.locator.LocatorUsage;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LoadSelectorFactory
extends CommonProcessorFactory {
    public static final String ID = "de.intarsys.processor.document.standard.LoadSelectorFactory";

    protected CommonProcessor basicCreateInstance(IArgs args) throws ObjectCreationException {
        LoadSelector processor = new LoadSelector((IFactory)this);
        ILocator locator = ArgTools.getLocator((IArgs)args, (String)"locator", null, (ILocatorFactory)DocumentEnvironment.get().getLocatorFactory());
        processor.setLocator(locator);
        String applicationContext = ArgTools.getString((IArgs)args, (String)"locatorApplicationContext", null);
        processor.setApplicationContext(applicationContext);
        ILocator dirLocator = ArgTools.getLocator((IArgs)args, (String)"directory", null, (ILocatorFactory)BasicLocatorFactory.get());
        if (dirLocator == null) {
            IDocumentType type;
            String extension2;
            String dirLocation = null;
            if (applicationContext != null && (dirLocation = LocatorUsage.get().getLastLocator("load", applicationContext)) == null) {
                dirLocation = LocatorUsage.get().getLastLocator("any", applicationContext);
            }
            if (dirLocation == null && (extension2 = ArgTools.getString((IArgs)args, (String)"extension", null)) != null && (type = DocumentTools.getDocumentTypeForExtension((String)extension2)) != null) {
                String documentContext = type.getId();
                dirLocation = LocatorUsage.get().getLastLocator("load", documentContext);
                if (dirLocation == null) {
                    dirLocation = LocatorUsage.get().getLastLocator("any", documentContext);
                }
            }
            if (dirLocation != null) {
                try {
                    dirLocator = BasicLocatorFactory.get().createLocator(dirLocation);
                    if (!dirLocator.isDirectory()) {
                        dirLocator = dirLocator.getParent();
                    }
                }
                catch (IOException extension2) {
                    // empty catch block
                }
            }
            if (dirLocator == null) {
                dirLocator = ArgTools.getLocator((IArgs)args, (String)"fallbackDirectory", null, (ILocatorFactory)BasicLocatorFactory.get());
            }
            if (dirLocator == null && (dirLocation = LocatorUsage.get().getLastLocator("load")) != null) {
                try {
                    dirLocator = BasicLocatorFactory.get().createLocator(dirLocation);
                    if (!dirLocator.isDirectory()) {
                        dirLocator = dirLocator.getParent();
                    }
                }
                catch (IOException extension2) {
                    // empty catch block
                }
            }
        }
        processor.setDirLocator(dirLocator);
        IDocumentType[] documentTypeFilter = null;
        Object argDocumentTypeFilter = args.get("documentTypeFilter");
        if (argDocumentTypeFilter instanceof IDocumentType) {
            documentTypeFilter = new IDocumentType[]{(IDocumentType)argDocumentTypeFilter};
        } else if (argDocumentTypeFilter instanceof IDocumentType[]) {
            documentTypeFilter = (IDocumentType[])argDocumentTypeFilter;
        } else if (argDocumentTypeFilter instanceof List) {
            List filterList = (List)argDocumentTypeFilter;
            documentTypeFilter = filterList.toArray(new IDocumentType[filterList.size()]);
        } else if (argDocumentTypeFilter instanceof String) {
            ArrayList<IDocumentType> tempTypes = new ArrayList<IDocumentType>();
            if (!StringTools.isEmpty((String)((String)argDocumentTypeFilter))) {
                String[] tempExtensionFilter;
                for (String extension : tempExtensionFilter = ((String)argDocumentTypeFilter).split(";")) {
                    IDocumentType tempType = DocumentTools.getDocumentTypeForExtension((String)extension);
                    if (tempType == null) continue;
                    tempTypes.add(tempType);
                }
            }
            if (!tempTypes.isEmpty()) {
                documentTypeFilter = tempTypes.toArray(new IDocumentType[tempTypes.size()]);
            }
        }
        processor.setDocumentTypeFilter(documentTypeFilter);
        return processor;
    }
}

