/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.processor.common;

import de.intarsys.processor.model.IProcessor;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.event.LifecycleWatchdog;
import de.intarsys.tools.factory.IBookkeepingFactory;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.IOutlet;
import java.util.List;

public abstract class ProcessorWatchdog
extends LifecycleWatchdog {
    private boolean replay = true;

    protected ProcessorWatchdog(IOutlet outlet) {
        this(outlet, true);
    }

    protected ProcessorWatchdog(IOutlet outlet, boolean replay) {
        super((INotificationSupport)outlet);
        this.replay = replay;
    }

    protected IOutlet getOutlet() {
        return (IOutlet)this.getObject();
    }

    protected void objectActivated(Object object) {
        this.processorActivated((IProcessor)object);
    }

    protected void objectCreated(Object object) {
        this.processorCreated((IProcessor)object);
    }

    protected void objectDeactivated(Object object) {
        this.processorDeactivated((IProcessor)object);
    }

    protected void objectStarted(Object object) {
        this.processorStarted((IProcessor)object);
    }

    protected void objectStopped(Object object) {
        this.processorStopped((IProcessor)object);
    }

    protected boolean objectStopRequested(Object object) {
        return this.processorStopRequested((IProcessor)object);
    }

    protected void processorActivated(IProcessor processor) {
    }

    protected void processorCreated(IProcessor processor) {
    }

    protected void processorDeactivated(IProcessor processor) {
    }

    protected void processorStarted(IProcessor processor) {
    }

    protected void processorStopped(IProcessor processor) {
    }

    protected boolean processorStopRequested(IProcessor processor) {
        return true;
    }

    public void start() {
        super.start();
        if (this.replay) {
            IOutlet outlet = (IOutlet)this.getObject();
            IFactory[] factories = outlet.getFactories();
            for (int i = 0; i < factories.length; ++i) {
                IFactory factory = factories[i];
                if (!(factory instanceof IBookkeepingFactory)) continue;
                List processors = ((IBookkeepingFactory)factory).getInstances();
                Object active = ((IBookkeepingFactory)factory).getActive();
                for (Object instance : processors) {
                    if (!this.supports(instance)) continue;
                    this.myObjectCreated(instance);
                    this.myObjectStarted(instance);
                    if (instance != active) continue;
                    this.myObjectActivated(instance);
                }
            }
        }
    }

    protected abstract boolean supports(IProcessor var1);

    protected final boolean supports(Object object) {
        if (object instanceof IProcessor) {
            return this.supports((IProcessor)object);
        }
        return false;
    }
}

