/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.security;

import de.intarsys.tools.authenticate.IPasswordValidator;
import de.intarsys.tools.crypto.Secret;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;

public class KeyStorePasswordVerifier
implements IPasswordValidator {
    private File file;
    private KeyStore keyStore;

    public KeyStorePasswordVerifier(File file, KeyStore keyStore) {
        this.file = file;
        this.keyStore = keyStore;
    }

    public KeyStorePasswordVerifier(File file, String keyStoreType, String keyStoreProvider) {
        this.file = file;
        try {
            this.keyStore = KeyStore.getInstance(keyStoreType, keyStoreProvider);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("underlying KeyStoreException", e);
        }
        catch (NoSuchProviderException e) {
            throw new IllegalStateException("underlying NoSuchProviderException", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid(Secret password) {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(this.file);
            this.keyStore.load(stream, password.getChars());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

