/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.timing;

import java.util.concurrent.Callable;

public class TimingTools {
    public static <V> Result<V> time(Callable<V> callable) {
        long start = System.currentTimeMillis();
        Object returnValue = null;
        Exception exception = null;
        try {
            returnValue = callable.call();
        }
        catch (Exception e) {
            exception = e;
        }
        long passedTime = System.currentTimeMillis() - start;
        return new Result<Object>(passedTime, returnValue, exception);
    }

    private TimingTools() {
    }

    public static class Result<V> {
        private final V returnValue;
        private final Exception exception;
        private final long passedTime;

        public Result(long passedTime, V returnValue, Exception exception) {
            this.passedTime = passedTime;
            this.returnValue = returnValue;
            this.exception = exception;
        }

        public V get() throws Exception {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.returnValue;
        }

        public long getPassedTime() {
            return this.passedTime;
        }
    }
}

