/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.presentation.common;

import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.presentation.common.PresentationSupportFactory;

public class PresentationWrapper
implements IPresentationSupport {
    private String defaultDescription;
    private String defaultIconName;
    private String defaultLabel;
    private String defaultTip;
    private Object description;
    private String iconName;
    private Object label;
    private Object object;
    private Object tip;
    private IPresentationSupport wrapped;

    public static PresentationWrapper create(Object object) {
        IPresentationSupport ps = PresentationSupportFactory.get().createPresentationSupport(object);
        return new PresentationWrapper(object, ps);
    }

    public PresentationWrapper(Object object, IPresentationSupport presentation) {
        this.object = object;
        this.wrapped = presentation;
    }

    public String getDefaultDescription() {
        if (this.defaultDescription == null) {
            return this.getTip();
        }
        return this.defaultDescription;
    }

    public String getDefaultIconName() {
        return this.defaultIconName;
    }

    public String getDefaultLabel() {
        if (this.defaultLabel == null) {
            return "";
        }
        return this.defaultLabel;
    }

    public String getDefaultTip() {
        if (this.defaultTip == null) {
            return this.getLabel();
        }
        return this.defaultTip;
    }

    public String getDescription() {
        if (this.description == null) {
            if (this.getWrappedDescription() != null) {
                return this.getWrappedDescription();
            }
            return this.getDefaultDescription();
        }
        if (this.description instanceof IMessage) {
            return ((IMessage)this.description).getString();
        }
        return (String)this.description;
    }

    public String getIconName() {
        if (this.iconName != null) {
            return this.iconName;
        }
        if (this.getWrappedIconName() != null) {
            return this.getWrappedIconName();
        }
        return this.getDefaultIconName();
    }

    public String getLabel() {
        if (this.label == null) {
            if (this.getWrappedLabel() != null) {
                return this.getWrappedLabel();
            }
            return this.getDefaultLabel();
        }
        if (this.label instanceof IMessage) {
            return ((IMessage)this.label).getString();
        }
        return (String)this.label;
    }

    public Object getObject() {
        return this.object;
    }

    public String getTip() {
        if (this.tip == null) {
            if (this.getWrappedTip() != null) {
                return this.getWrappedTip();
            }
            return this.getDefaultTip();
        }
        if (this.tip instanceof IMessage) {
            return ((IMessage)this.tip).getString();
        }
        return (String)this.tip;
    }

    protected String getWrappedDescription() {
        if (this.wrapped == null) {
            return null;
        }
        return this.wrapped.getDescription();
    }

    protected String getWrappedIconName() {
        if (this.wrapped == null) {
            return null;
        }
        return this.wrapped.getIconName();
    }

    protected String getWrappedLabel() {
        if (this.wrapped == null) {
            return null;
        }
        return this.wrapped.getLabel();
    }

    protected String getWrappedTip() {
        if (this.wrapped == null) {
            return null;
        }
        return this.wrapped.getTip();
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public boolean hasIconName() {
        return this.iconName != null;
    }

    public boolean hasLabel() {
        return this.label != null;
    }

    public boolean hasTip() {
        return this.tip != null;
    }

    public void setDefaultDescription(String defaultDescription) {
        this.defaultDescription = defaultDescription;
    }

    public void setDefaultIconName(String defaultIconName) {
        this.defaultIconName = defaultIconName;
    }

    public void setDefaultLabel(String defaultLabel) {
        this.defaultLabel = defaultLabel;
    }

    public void setDefaultTip(String defaultTip) {
        this.defaultTip = defaultTip;
    }

    public void setDescription(Object description) {
        String oldValue;
        this.description = description == null ? null : (description.equals(oldValue = this.getWrappedDescription()) ? null : description);
    }

    public void setIconName(String iconName) {
        String oldValue;
        this.iconName = iconName == null ? null : (iconName.equals(oldValue = this.getWrappedIconName()) ? null : iconName);
    }

    public void setLabel(Object label) {
        String oldLabel;
        this.label = label == null ? null : (label.equals(oldLabel = this.getWrappedLabel()) ? null : label);
    }

    public void setObject(Object object) {
        this.object = object;
        this.wrapped = PresentationSupportFactory.get().createPresentationSupport(object);
        if (this.wrapped != null) {
            this.setDescription(this.description);
            this.setIconName(this.iconName);
            this.setLabel(this.label);
            this.setTip(this.tip);
        }
    }

    public void setTip(Object tip) {
        String oldValue;
        this.tip = tip == null ? null : (tip.equals(oldValue = this.getWrappedTip()) ? null : tip);
    }
}

