/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.jmx;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.string.StringTools;
import java.util.regex.Pattern;
import javax.management.Notification;
import javax.management.NotificationFilter;

public class SimpleJMXNotificationFilter
implements NotificationFilter,
IElementConfigurable,
IElementSerializable {
    private String type;
    private Pattern typePattern;
    private String message;
    private Pattern messagePattern;

    public void configure(IElement element) throws ConfigurationException {
        this.setType(element.attributeValue("type", this.getType()));
        this.setMessage(element.attributeValue("message", this.getMessage()));
    }

    public String getMessage() {
        return this.message;
    }

    protected Pattern getMessagePattern() {
        return this.messagePattern;
    }

    public String getType() {
        return this.type;
    }

    protected Pattern getTypePattern() {
        return this.typePattern;
    }

    @Override
    public boolean isNotificationEnabled(Notification notification) {
        if (this.getTypePattern() != null && !this.getTypePattern().matcher(notification.getType()).matches()) {
            return false;
        }
        return this.getMessagePattern() == null || this.getMessagePattern().matcher(notification.getMessage()).matches();
    }

    public void serialize(IElement element) throws ElementSerializationException {
        element.setAttributeValue("class", this.getClass().getName());
        element.setAttributeValue("type", this.getType());
        element.setAttributeValue("message", this.getMessage());
    }

    public void setMessage(String message) {
        this.message = message;
        this.messagePattern = StringTools.isEmpty((String)message) ? null : Pattern.compile(message);
    }

    public void setType(String type) {
        this.type = type;
        this.typePattern = StringTools.isEmpty((String)type) ? null : Pattern.compile(type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    protected void toString(StringBuilder sb) {
        if (!StringTools.isEmpty((String)this.getType())) {
            if (sb.length() != 0) {
                sb.append(" &&&&\n");
            }
            sb.append("\ttype matches '");
            sb.append(this.getType());
            sb.append("'");
        }
        if (!StringTools.isEmpty((String)this.getMessage())) {
            if (sb.length() != 0) {
                sb.append(" &&&&\n");
            }
            sb.append("\tmessage matches '");
            sb.append(this.getMessage());
            sb.append("'");
        }
    }
}

