/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.jmx;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.component.IContextSupport;
import de.intarsys.tools.concurrent.ThreadTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.jmx.IJMXNotificationSink;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class JMXNotificationSink
implements IJMXNotificationSink,
IElementConfigurable,
IContextSupport,
IElementSerializable {
    private static final Executor DEFAULT_EXECUTOR = Executors.newSingleThreadExecutor(ThreadTools.newThreadFactoryDaemon((String)"JMXNotificationSink"));
    private NotificationFilter notificationFilter;
    private NotificationListener notificationListener;
    private ObjectName objectName;
    private Object handback;
    private Object context;
    private Executor executor;

    public void configure(IElement element) throws ConfigurationException {
        try {
            IElement filterElement = element.element("filter");
            this.notificationFilter = (NotificationFilter)ElementTools.createObject((IElement)filterElement, NotificationFilter.class, (Object)this.getContext(), (IArgs)Args.create());
            IElement listenerElement = element.element("listener");
            this.notificationListener = (NotificationListener)ElementTools.createObject((IElement)listenerElement, NotificationListener.class, (Object)this.getContext(), (IArgs)Args.create());
            IElement executorElement = element.element("executor");
            this.executor = (Executor)ElementTools.createObject((IElement)executorElement, Executor.class, (Object)this.getContext(), (IArgs)Args.create());
            IElement nameElement = element.element("name");
            if (nameElement != null) {
                this.objectName = ObjectName.getInstance(nameElement.attributeValue("value", null));
            }
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public Object getContext() {
        return this.context;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public Object getHandback() {
        return this.handback;
    }

    @Override
    public NotificationFilter getNotificationFilter() {
        return this.notificationFilter;
    }

    @Override
    public NotificationListener getNotificationListener() {
        return this.notificationListener;
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public final void handleNotification(Notification notification, Object handback) {
        Runnable runnable = () -> this.getNotificationListener().handleNotification(notification, handback);
        (this.executor == null ? DEFAULT_EXECUTOR : this.executor).execute(runnable);
    }

    public void serialize(IElement element) throws ElementSerializationException {
        element.setAttributeValue("class", this.getClass().getName());
        element.setName("sink");
        if (this.getNotificationListener() instanceof IElementSerializable) {
            IElement listenerElement = element.newElementMapped("listener");
            ((IElementSerializable)this.getNotificationListener()).serialize(listenerElement);
        }
        if (this.getNotificationFilter() instanceof IElementSerializable) {
            IElement filterElement = element.newElementMapped("filter");
            ((IElementSerializable)this.getNotificationFilter()).serialize(filterElement);
        }
        if (this.getExecutor() instanceof IElementSerializable) {
            IElement executorElement = element.newElementMapped("executor");
            ((IElementSerializable)this.getExecutor()).serialize(executorElement);
        }
        if (this.objectName != null) {
            IElement nameElement = element.newElementMapped("name");
            nameElement.setAttributeValue("value", this.objectName.getCanonicalName());
        }
    }

    public void setContext(Object context) {
        this.context = context;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void setHandback(Object handback) {
        this.handback = handback;
    }

    public void setNotificationFilter(NotificationFilter filter) {
        this.notificationFilter = filter;
    }

    public void setNotificationListener(NotificationListener notificationListener) {
        this.notificationListener = notificationListener;
    }

    public void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    protected void toString(StringBuilder sb) {
        sb.append("Wenn\n");
        sb.append("\tNachricht von ");
        sb.append(this.objectName);
        if (this.notificationFilter != null) {
            sb.append(" &&&&\n");
            sb.append(this.notificationFilter.toString());
        }
        sb.append("\nDann\n");
        if (this.notificationListener != null) {
            sb.append("\t");
            sb.append(this.notificationListener.toString());
        }
    }
}

