/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.feature;

import de.intarsys.tools.feature.IObjectFeature;
import de.intarsys.tools.feature.IObjectFeatureImpl;
import de.intarsys.tools.feature.IObjectFeatureRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObjectFeatureRegistry
implements IObjectFeatureRegistry {
    private Map features = new HashMap();

    @Override
    public IObjectFeatureImpl lookupFeatureImpl(IObjectFeature feature, Object object) {
        List implementations = (List)this.features.get(feature);
        if (implementations == null) {
            return null;
        }
        for (IObjectFeatureImpl implementation : implementations) {
            if (!implementation.supports(object)) continue;
            return implementation;
        }
        return null;
    }

    @Override
    public void registerFeatureImpl(IObjectFeature feature, IObjectFeatureImpl featureImpl) {
        if (!feature.acceptImpl(featureImpl)) {
            throw new IllegalArgumentException("Cannot register implementation for feature '" + feature.getId() + "'");
        }
        List implementations = (List)this.features.computeIfAbsent(feature, ignore -> new ArrayList());
        if (implementations.contains(featureImpl)) {
            return;
        }
        implementations.add(featureImpl);
    }

    @Override
    public void unregisterFeatureImpl(IObjectFeature feature, IObjectFeatureImpl featureImpl) {
        List implementations = (List)this.features.get(feature);
        if (implementations == null) {
            return;
        }
        implementations.remove(featureImpl);
    }
}

