/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.componentinfo;

import de.intarsys.tools.component.ComponentInfo;
import de.intarsys.tools.string.StringTools;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallLogInfo {
    private static final Logger Log = LoggerFactory.getLogger(InstallLogInfo.class);

    protected String createMessage(ComponentInfo info, int level) {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < level - 1; ++i) {
            sb.append("   ");
        }
        if (i < level) {
            sb.append("+--");
        }
        sb.append(info.toStringShort());
        return sb.toString();
    }

    public ComponentInfo getComponentInfo() {
        ComponentInfo info = new ComponentInfo();
        info.createChildren();
        return info;
    }

    protected void logComponentInfo() {
        ComponentInfo info = this.getComponentInfo();
        Log.info("version info:");
        this.logComponentInfo(info, 0);
    }

    protected void logComponentInfo(ComponentInfo info, int level) {
        if (!StringTools.isEmpty((String)info.getVersion())) {
            Log.info(this.createMessage(info, level));
        }
        for (ComponentInfo child : info.getChildren()) {
            this.logComponentInfo(child, level + 1);
        }
    }

    @PostConstruct
    public void perform() {
        this.logComponentInfo();
    }
}

