/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.widget.format;

import de.intarsys.pdf.design.widget.format.FieldFormat;
import java.util.Arrays;
import java.util.List;

public abstract class PatternFormat
extends FieldFormat {
    private String pattern = this.getDefaultPattern();

    public PatternFormat() {
    }

    public PatternFormat(String pattern) {
        this.setPattern(pattern);
    }

    public PatternFormat(int index) {
        this.setPatternIndex(index);
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public int getPatternIndex() {
        return this.getPatternIndex(this.getPattern());
    }

    public void setPatternIndex(int index) {
        this.pattern = this.getBuiltInPatterns()[index];
    }

    protected String createScript(String method, String pattern) {
        StringBuilder script = new StringBuilder();
        script.append(method);
        script.append("(\"").append(pattern).append("\");");
        return script.toString();
    }

    protected String createScript(String method, int index) {
        StringBuilder script = new StringBuilder();
        script.append(method);
        script.append("(").append(index).append(");");
        return script.toString();
    }

    public String getPatternLabel(String pattern) {
        int index = this.getPatternIndex(pattern);
        if (index > -1) {
            return this.getPatternLabel(index);
        }
        return pattern;
    }

    protected int getPatternIndex(String pattern) {
        String[] input = this.getBuiltInPatterns();
        for (int i = 0; i < input.length; ++i) {
            if (!input[i].equals(pattern)) continue;
            return i;
        }
        return -1;
    }

    public List getDisplayPatterns() {
        return Arrays.asList(this.getBuiltInPatterns());
    }

    public abstract String[] getBuiltInPatterns();

    protected abstract String getPatternLabel(int var1);

    protected abstract String getDefaultPattern();
}

