/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.widget.format;

import de.intarsys.pdf.cds.CDSNameTreeNode;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSCatalog;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAction;
import de.intarsys.pdf.pd.PDActionJavaScript;
import de.intarsys.pdf.pd.PDAdditionalActions;
import de.intarsys.pdf.pd.PDDocument;

public class JSFieldTools {
    public static final COSName DK_JavaScript = COSName.constant((String)"JavaScript");

    public static String getJavaScript(PDAcroFormField field, COSName trigger) {
        PDAdditionalActions aa = field.getAdditionalActions();
        if (aa == null) {
            return null;
        }
        PDAction action = aa.getAction(trigger);
        if (action == null || !(action instanceof PDActionJavaScript)) {
            return null;
        }
        PDActionJavaScript jsAction = (PDActionJavaScript)action;
        return jsAction.getJavaScript();
    }

    public static void setDocumentJavaScript(PDDocument doc, String name, String source) {
        COSArray jsNames;
        COSDictionary jsTree;
        COSCatalog catalog;
        if (source != null && source.length() == 0) {
            source = null;
        }
        if ((catalog = doc.getCatalog()) == null) {
            return;
        }
        COSDictionary names = catalog.cosGetNames();
        if (names == null) {
            if (source == null) {
                return;
            }
            names = COSDictionary.create();
            catalog.cosSetField(COSCatalog.DK_Names, (COSObject)names);
        }
        if ((jsTree = names.get(DK_JavaScript).asDictionary()) == null) {
            if (source == null) {
                return;
            }
            jsTree = COSDictionary.create();
            names.put(DK_JavaScript, (COSObject)jsTree);
        }
        if ((jsNames = jsTree.get(CDSNameTreeNode.DK_Names).asArray()) == null) {
            if (source == null) {
                return;
            }
            jsNames = COSArray.create();
            jsTree.put(CDSNameTreeNode.DK_Names, (COSObject)jsNames);
        }
        COSString cosName = COSString.create((String)name);
        int index = -1;
        int jsNameIndex = 0;
        for (COSObject jsName : jsNames) {
            if (cosName.equals((Object)jsName)) {
                index = jsNameIndex;
                break;
            }
            ++jsNameIndex;
        }
        if (index > -1) {
            if (source == null) {
                jsNames.remove(index);
                jsNames.remove(index);
            }
        } else if (source != null) {
            PDActionJavaScript action = PDActionJavaScript.createNew((String)source);
            COSDictionary actionDefinition = action.cosGetDict();
            actionDefinition.remove(PDAction.DK_Type);
            jsNames.add((COSObject)cosName);
            jsNames.add((COSObject)actionDefinition);
        }
    }

    public static void setJavaScript(PDAcroFormField field, COSName trigger, String source) {
        PDAdditionalActions aa;
        if (source != null && source.length() == 0) {
            source = null;
        }
        if ((aa = field.getAdditionalActions()) == null) {
            if (source == null) {
                return;
            }
            aa = (PDAdditionalActions)PDAdditionalActions.META.createNew();
            field.setAdditionalActions(aa);
        }
        PDActionJavaScript action = null;
        if (source != null) {
            action = PDActionJavaScript.createNew((String)source);
        }
        aa.setAction(trigger, (PDAction)action);
    }
}

