/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.page;

import de.intarsys.pdf.app.appearance.AppearanceCreatorTools;
import de.intarsys.pdf.app.design.AnnotationDesignerException;
import de.intarsys.pdf.app.page.EnumPageSize;
import de.intarsys.pdf.app.page.MultiPageSelector;
import de.intarsys.pdf.app.page.PageSelector;
import de.intarsys.pdf.design.tools.FormTools;
import de.intarsys.pdf.pd.PDAcroForm;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDPageNode;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.range.IRangeContext;
import de.intarsys.tools.range.RangeTools;
import de.intarsys.tools.string.StringTools;
import java.awt.geom.Point2D;
import java.util.List;

public class PageTools {
    public static final String ARG_PAGE = "page";
    public static final String ARG_PAGERANGE = "pageRange";
    public static final String ARG_PAGERANGECONTEXT = "pageRangeContext";
    public static final String ARG_PAGESIZE = "pageSize";
    public static final String ARG_PAGEWIDTH = "pageWidth";
    public static final String ARG_PAGEHEIGHT = "pageHeight";

    public static void appendPageCopy(PDDocument doc, PDPage page, String fieldNamePrefix) {
        PDPage pageCopy = (PDPage)PDPage.META.createFromCos(page.cosGetObject().copyDeep());
        doc.getPageTree().addNode((PDPageNode)pageCopy);
        PageTools.pdImportFields(doc, pageCopy, fieldNamePrefix);
    }

    public static PageSelector getPageSelector(IArgs args, IRangeContext pRangeContext) {
        String pageRange = ArgTools.getString((IArgs)args, (String)ARG_PAGERANGE, null);
        IRangeContext rangeContext = RangeTools.getRangeContext((IArgs)args, (String)ARG_PAGERANGECONTEXT, (IRangeContext)pRangeContext);
        return new MultiPageSelector(pageRange, rangeContext);
    }

    public static Point2D getPageSize(IArgs args) {
        String pageSizeString = ArgTools.getString((IArgs)args, (String)ARG_PAGESIZE, (String)EnumPageSize.META.getDefault().getId()).trim();
        if (StringTools.isNumeric((String)pageSizeString)) {
            return ArgTools.getPointStrict((IArgs)args, (String)ARG_PAGESIZE, (String)ARG_PAGEWIDTH, (String)ARG_PAGEHEIGHT, null);
        }
        EnumPageSize pageSize = (EnumPageSize)EnumPageSize.META.getItemStrictOrDefault(pageSizeString);
        return new Point2D.Float(pageSize.getWidth(), pageSize.getHeight());
    }

    protected static void pdImportFields(PDDocument doc, PDPage page, String namePrefix) {
        List annots = page.getAnnotations();
        if (annots == null) {
            return;
        }
        page.cosRemoveField(PDPage.DK_Annots);
        for (PDAnnotation annot : annots) {
            if (annot.isWidgetAnnotation()) {
                PDWidgetAnnotation widget = (PDWidgetAnnotation)annot;
                PDAcroForm form = doc.getAcroForm();
                if (form == null) {
                    form = FormTools.createAcroForm(doc);
                }
                Object newName = widget.getAcroFormField().getQualifiedName();
                if (namePrefix != null) {
                    newName = namePrefix + (String)newName;
                }
                try {
                    widget = FormTools.importWidget(widget, form, (String)newName);
                }
                catch (AnnotationDesignerException e) {
                    e.printStackTrace();
                    continue;
                }
                page.addAnnotation((PDAnnotation)widget);
                AppearanceCreatorTools.createAppearance((PDAcroFormField)widget.getAcroFormField());
                continue;
            }
            page.addAnnotation(annot);
        }
    }

    private PageTools() {
    }
}

