/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.claptz.io;

import de.intarsys.claptz.IExtension;
import de.intarsys.claptz.IInstrumentPrerequisite;
import de.intarsys.claptz.impl.StandardInstrument;
import de.intarsys.claptz.impl.StandardInstrumentPrerequisite;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.IStringEvaluatorAccess;
import de.intarsys.tools.infoset.IAttribute;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.serialize.SerializationContext;
import de.intarsys.tools.serialize.xml.XMLSerializer;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.util.Iterator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class InstrumentSerializer
extends XMLSerializer {
    private static final String ATTR_ID = "id";
    private static final String ATTR_ABSENT = "absent";
    private static final String EL_REQUIRES = "requires";
    private static final String EL_PREREQUISITE = "prerequisite";
    private static final String EL_INSTRUMENT = "instrument";

    public InstrumentSerializer(SerializationContext context) {
        super(context);
    }

    public InstrumentSerializer(SerializationContext context, boolean createDocument) {
        super(context, createDocument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serialize(IElement element, ContentHandler handler) throws SAXException {
        IStringEvaluator oldValue = null;
        try {
            if (element instanceof IStringEvaluatorAccess) {
                oldValue = ((IStringEvaluatorAccess)element).getStringEvaluator();
                ((IStringEvaluatorAccess)element).setStringEvaluator(null);
            }
            AttributesImpl attrs = new AttributesImpl();
            Iterator iter = element.attributeIterator();
            while (iter.hasNext()) {
                IAttribute attribute = (IAttribute)iter.next();
                Object raw = attribute.getRaw();
                if (raw == null) continue;
                InstrumentSerializer.addAttribute((AttributesImpl)attrs, (String)attribute.getName(), (String)StringTools.safeString((Object)raw));
            }
            this.doStartElement(handler, element.getName(), attrs);
            Iterator it = element.elementIterator();
            while (it.hasNext()) {
                IElement childElement = (IElement)it.next();
                this.serialize(childElement, handler);
            }
            this.doEndElement(handler, element.getName());
        }
        finally {
            if (element instanceof IStringEvaluatorAccess) {
                ((IStringEvaluatorAccess)element).setStringEvaluator(oldValue);
            }
        }
    }

    public void serialize(Object object, ContentHandler handler) throws SAXException, IOException {
        this.serialize((StandardInstrument)object, handler);
    }

    protected void serialize(StandardInstrument instrument, ContentHandler handler) throws SAXException, IOException {
        AttributesImpl attrs = new AttributesImpl();
        InstrumentSerializer.addAttribute((AttributesImpl)attrs, (String)ATTR_ID, (String)instrument.getId());
        this.doStartElement(handler, EL_INSTRUMENT, attrs);
        attrs = new AttributesImpl();
        this.doStartElement(handler, EL_REQUIRES, attrs);
        for (IInstrumentPrerequisite prerequisite : instrument.getPrerequisites()) {
            attrs = new AttributesImpl();
            InstrumentSerializer.addAttribute((AttributesImpl)attrs, (String)EL_INSTRUMENT, (String)prerequisite.getInstrumentId());
            if (((StandardInstrumentPrerequisite)prerequisite).getAbsentAction() != null) {
                InstrumentSerializer.addAttribute((AttributesImpl)attrs, (String)ATTR_ABSENT, (String)((StandardInstrumentPrerequisite)prerequisite).getAbsentAction());
            }
            this.doStartElement(handler, EL_PREREQUISITE, attrs);
            this.doEndElement(handler, EL_PREREQUISITE);
        }
        this.doEndElement(handler, EL_REQUIRES);
        for (IExtension extension : instrument.getExtensions()) {
            this.serialize(extension.getElement(), handler);
        }
        this.doEndElement(handler, EL_INSTRUMENT);
    }
}

