/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.claptz.impl;

import de.intarsys.claptz.IExtension;
import de.intarsys.claptz.IExtensionPoint;
import de.intarsys.claptz.IExtensionPointHandler;
import de.intarsys.claptz.IInstrument;
import de.intarsys.claptz.IInstrumentPrerequisite;
import de.intarsys.claptz.IInstrumentRegistry;
import de.intarsys.claptz.InstrumentRegistryException;
import de.intarsys.claptz.StateExcluded;
import de.intarsys.claptz.StateFailed;
import de.intarsys.claptz.StatePrepared;
import de.intarsys.claptz.impl.ExtensionPointHandlerAdapter;
import de.intarsys.claptz.impl.PACKAGE;
import de.intarsys.claptz.impl.StandardExtensionPoint;
import de.intarsys.claptz.impl.StandardInstrument;
import de.intarsys.claptz.impl.StandardInstrumentPrerequisite;
import de.intarsys.claptz.io.IInstrumentStore;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.bean.LifecycleDispatcher;
import de.intarsys.tools.collection.ReverseListIterator;
import de.intarsys.tools.component.IStartStop;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.event.StartedEvent;
import de.intarsys.tools.event.StopRequestedEvent;
import de.intarsys.tools.event.StoppedEvent;
import de.intarsys.tools.format.Format;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.lang.Aliases;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.reporter.Reporter;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class StandardInstrumentRegistry
implements IStartStop,
INotificationSupport,
IAttributeSupport,
IInstrumentRegistry {
    private static final String ATTR_INSTALLER = "installer";
    private static final String ATTR_ID = "id";
    private static final String SEPARATOR = ";";
    private static final int DEFAULT_SIZE = 100;
    public static final String XE_EXTENSIONPOINT = "extensionpoint";
    public static final String XP_EXTENSIONPOINTS = "de.intarsys.claptz.extensionpoints";
    private static final Logger Log = LoggerFactory.getLogger(StandardInstrumentRegistry.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;
    public static final String ACTION_DEFAULT = null;
    public static final String ACTION_FAIL = "fail";
    public static final String ACTION_IGNORE = "ignore";
    public static final String ACTION_SKIP = "skip";
    private Map<String, IExtensionPoint> extensionPoints = new LinkedHashMap<String, IExtensionPoint>();
    private final IExtensionPointHandler extensionPointInstaller = new ExtensionPointHandlerAdapter(){

        @Override
        protected Object basicInstallInsert(IExtension extension, IElement element) {
            if (StandardInstrumentRegistry.XE_EXTENSIONPOINT.equals(element.getName())) {
                IInstrument instrument = StandardInstrumentRegistry.this.lookupInstrument(extension.getProvider().getId());
                StandardExtensionPoint newEP = StandardInstrumentRegistry.this.createExtensionPoint((StandardInstrument)instrument, element);
                try {
                    if (element.attributeValue(StandardInstrumentRegistry.ATTR_INSTALLER, null) != null) {
                        IExtensionPointHandler installer = (IExtensionPointHandler)ElementTools.createObject((IElement)element, (String)StandardInstrumentRegistry.ATTR_INSTALLER, IExtensionPointHandler.class, (Object)extension.getProvider(), (IArgs)Args.create());
                        newEP.setInstaller(installer);
                    }
                    StandardInstrumentRegistry.this.registerExtensionPoint(newEP);
                }
                catch (Exception e) {
                    String msg = "error installing extension";
                    this.log(Log, Level.ERROR, extension, element, msg, e);
                }
            } else {
                return super.basicInstallInsert(extension, element);
            }
            return null;
        }

        @Override
        protected void basicUninstall(IExtension extension, IElement element) {
            if (StandardInstrumentRegistry.XE_EXTENSIONPOINT.equals(element.getName())) {
                String id = element.attributeValue(StandardInstrumentRegistry.ATTR_ID, null);
                IExtensionPoint newEP = StandardInstrumentRegistry.this.lookupExtensionPoint(id);
                if (newEP != null) {
                    try {
                        StandardInstrumentRegistry.this.unregisterExtensionPoint(newEP);
                    }
                    catch (InstrumentRegistryException e) {
                        Log.error("error unregistering extension {}", (Object)StringTools.safeString((Object)extension), (Object)e);
                    }
                }
            } else {
                super.basicUninstall(extension, element);
            }
        }
    };
    private EventDispatcher dispatcher = new EventDispatcher((Object)this);
    private AttributeMap attributes = new AttributeMap();
    private ClassLoader classLoader;
    private Set<StandardInstrument> failedInstruments = new HashSet<StandardInstrument>();
    private final Map<String, IInstrument> instruments = new LinkedHashMap<String, IInstrument>();
    private boolean started;
    private Set<StandardInstrument> startedInstruments = new HashSet<StandardInstrument>();
    private List<StandardInstrument> startList;
    private StandardInstrument rootInstrument;
    private final List<IInstrumentStore> stores = new ArrayList<IInstrumentStore>();
    private final Set<String> defines = new HashSet<String>();
    private LifecycleDispatcher lifecycleDispatcher = new LifecycleDispatcher("container.lifecycle");

    public StandardInstrumentRegistry() {
        this.classLoader = Thread.currentThread().getContextClassLoader();
        if (this.classLoader == null) {
            this.classLoader = this.getClass().getClassLoader();
        }
        try {
            this.rootInstrument = new StandardInstrument(this, null);
            this.rootInstrument.setStartLevel(0);
            StandardExtensionPoint root = new StandardExtensionPoint(this.rootInstrument, XP_EXTENSIONPOINTS);
            root.setInstaller(this.extensionPointInstaller);
            this.registerExtensionPoint(root);
        }
        catch (InstrumentRegistryException e) {
            throw new IllegalStateException("can't register de.intarsys.claptz.extensionpoints", e);
        }
    }

    public void addInstrumentStore(IInstrumentStore store) {
        this.stores.add(store);
    }

    public <T extends Event> void addNotificationListener(EventType<? extends T> type, INotificationListener<T> listener) {
        this.dispatcher.addNotificationListener(type, listener);
    }

    protected void buildStartList(List<StandardInstrument> startList, StandardInstrument instrument) {
        if (!instrument.getState().isNew()) {
            return;
        }
        if (!this.ppIsDefined(instrument.getIfdef())) {
            String reason = "ifdef " + instrument.getIfdef() + " not defined";
            Log.info("{} exclude instrument '{}' defined in {}", new Object[]{reason, instrument.getId(), instrument.getBaseDir()});
            instrument.setState(new StateExcluded(reason));
            return;
        }
        if (!this.ppIsNotDefined(instrument.getIfnotdef())) {
            String reason = Format.printf((String)"ifnotdef %s defined", (Object[])new Object[]{instrument.getIfnotdef()});
            Log.info("{} exclude instrument '{}' defined in {}", new Object[]{reason, instrument.getId(), instrument.getBaseDir()});
            instrument.setState(new StateExcluded(reason));
            return;
        }
        List<IInstrumentPrerequisite> prerequisites = instrument.getPrerequisites();
        for (IInstrumentPrerequisite pre : prerequisites) {
            this.buildStartListPrerequisite(startList, instrument, (StandardInstrumentPrerequisite)pre);
        }
        if (!instrument.getState().isFailed() && !instrument.getState().isExcluded()) {
            instrument.setState(new StatePrepared(""));
            startList.add(instrument);
        }
    }

    protected void buildStartListPrerequisite(List<StandardInstrument> startList, StandardInstrument instrument, StandardInstrumentPrerequisite prerequisite) {
        block9: {
            if (!this.ppIsDefined(prerequisite.getIfdef())) {
                String reason = Format.printf((String)"ifdef %s not defined", (Object[])new Object[]{prerequisite.getIfdef()});
                Log.info("{}, exclude prerequisite '{}' for '{}' defined in {}", new Object[]{reason, prerequisite.getInstrumentId(), instrument.getId(), instrument.getBaseDir()});
                prerequisite.setState(new StateExcluded(reason));
                return;
            }
            if (!this.ppIsNotDefined(prerequisite.getIfnotdef())) {
                String reason = "ifnotdef " + prerequisite.getIfnotdef() + " defined";
                Log.info(reason + ", exclude prerequisite '" + prerequisite.getInstrumentId() + "' for '" + instrument.getId() + "' defined in " + instrument.getBaseDir());
                prerequisite.setState(new StateExcluded(reason));
                return;
            }
            IInstrument preInstrument = prerequisite.getInstrument();
            if (preInstrument != null) {
                this.buildStartList(startList, (StandardInstrument)preInstrument);
            }
            if (preInstrument == null || preInstrument.getState().isFailed() || preInstrument.getState().isExcluded()) {
                String action = prerequisite.getAbsentAction();
                String reason = Format.printf((String)"missing prerequisite '%s'", (Object[])new Object[]{prerequisite.getInstrumentId()});
                try {
                    if (action == ACTION_DEFAULT || action.equals(ACTION_FAIL)) {
                        String msg = Format.printf((String)"fail: %s  in '%s' defined in %s", (Object[])new Object[]{reason, instrument.getId(), instrument.getBaseDir()});
                        InstrumentRegistryException ex = new InstrumentRegistryException(msg);
                        prerequisite.setState(new StateFailed(reason));
                        instrument.setState(new StateFailed(reason));
                        throw ex;
                    }
                    if (action.equals(ACTION_IGNORE)) {
                        Log.info("ignore: {} in '{}' defined in {}", new Object[]{reason, instrument.getId(), instrument.getBaseDir()});
                        prerequisite.setState(new StateExcluded(reason));
                        break block9;
                    }
                    if (action.equals(ACTION_SKIP)) {
                        Log.info("skip: {} in '{}' defined in {}", new Object[]{reason, instrument.getId(), instrument.getBaseDir()});
                        prerequisite.setState(new StateExcluded(reason));
                        instrument.setState(new StateExcluded(reason));
                        break block9;
                    }
                    InstrumentRegistryException ex = new InstrumentRegistryException("absent action '" + action + "' not recognized in '" + instrument.getId() + "' defined in " + instrument.getBaseDir());
                    prerequisite.setState(new StateFailed(reason));
                    instrument.setState(new StateFailed(reason));
                    throw ex;
                }
                catch (InstrumentRegistryException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
        }
    }

    protected StandardExtensionPoint createExtensionPoint(StandardInstrument instrument, IElement childElement) {
        String id = childElement.attributeValue(ATTR_ID, null);
        return new StandardExtensionPoint(instrument, id);
    }

    @Override
    public IInstrument createInstrument(String id, IInstrumentStore store) {
        StandardInstrument instrument = new StandardInstrument(this, store);
        instrument.setId(id);
        return instrument;
    }

    public void flush() throws IOException {
    }

    public Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public List<IExtensionPoint> getExtensionPoints() {
        return new ArrayList<IExtensionPoint>(this.extensionPoints.values());
    }

    @Override
    public List<IInstrument> getInstruments() {
        return new ArrayList<IInstrument>(this.instruments.values());
    }

    public List<IInstrumentStore> getStores() {
        return this.stores;
    }

    protected boolean isFailed(StandardInstrument instrument) {
        return this.failedInstruments.contains(instrument);
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isStarted() {
        return this.started;
    }

    protected boolean isStarted(StandardInstrument instrument) {
        return this.startedInstruments.contains(instrument);
    }

    @Override
    public void load(IInstrumentStore store) throws InstrumentRegistryException {
        store.load(this);
    }

    @Override
    public IExtensionPoint lookupExtensionPoint(String name) {
        String resolvedName = Aliases.get().resolve(name);
        return this.extensionPoints.get(resolvedName);
    }

    @Override
    public IInstrument lookupInstrument(String name) {
        String resolvedName = Aliases.get().resolve(name);
        return this.instruments.get(resolvedName);
    }

    @Override
    public void ppDefine(String symbolList) {
        String[] symbols;
        if (symbolList == null) {
            return;
        }
        for (String symbol : symbols = symbolList.split(SEPARATOR)) {
            String trimmed = symbol.trim();
            if (trimmed.length() <= 0) continue;
            this.defines.add(trimmed);
        }
    }

    @Override
    public Set<String> ppGetDefines() {
        return new HashSet<String>(this.defines);
    }

    public boolean ppIsDefined(String symbolList) {
        String[] symbols;
        if (symbolList == null) {
            return true;
        }
        for (String symbol : symbols = symbolList.split(SEPARATOR)) {
            String trimmed = symbol.trim();
            if (trimmed.length() <= 0 || this.defines.contains(trimmed)) continue;
            return false;
        }
        return true;
    }

    public boolean ppIsNotDefined(String symbolList) {
        String[] symbols;
        if (symbolList == null) {
            return true;
        }
        for (String symbol : symbols = symbolList.split(SEPARATOR)) {
            String trimmed = symbol.trim();
            if (trimmed.length() <= 0 || !this.defines.contains(trimmed)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void ppUndefine(String symbolList) {
        String[] symbols;
        if (symbolList == null) {
            return;
        }
        for (String symbol : symbols = symbolList.split(SEPARATOR)) {
            String trimmed = symbol.trim();
            this.defines.remove(trimmed);
        }
    }

    protected void registerExtensionPoint(StandardExtensionPoint extensionPoint) throws InstrumentRegistryException {
        IExtensionPoint prev = this.extensionPoints.get(extensionPoint.getId());
        if (prev != null) {
            return;
        }
        Log.debug("register {}", (Object)StringTools.safeString((Object)extensionPoint));
        this.extensionPoints.put(extensionPoint.getId(), extensionPoint);
        if (extensionPoint.getInstaller() != null) {
            extensionPoint.getInstaller().setExtensionPoint(extensionPoint);
            if (!extensionPoint.getInstaller().isDeferred()) {
                extensionPoint.getInstaller().install();
            }
        }
    }

    @Override
    public void registerInstrument(IInstrument instrument) throws InstrumentRegistryException {
        String id = instrument.getId();
        if (this.instruments.get(id) != null) {
            throw new InstrumentRegistryException(Msg.getString("StandardInstrumentRegistry.ExAlreadyRegistered", new Object[]{instrument.getId()}));
        }
        this.ppDefine(id);
        this.instruments.put(id, instrument);
        if (this.isStarted()) {
            ((StandardInstrument)instrument).start();
            ((StandardInstrument)instrument).triggerStarted();
        }
    }

    public Object removeAttribute(Object key) {
        return this.attributes.removeAttribute(key);
    }

    public <T extends Event> void removeNotificationListener(EventType<? extends T> type, INotificationListener<T> listener) {
        this.dispatcher.removeNotificationListener(type, listener);
    }

    public Object setAttribute(Object key, Object value) {
        return this.attributes.setAttribute(key, value);
    }

    public void start() {
        this.started = true;
        this.startList = new ArrayList<StandardInstrument>(100);
        ArrayList<IInstrument> tempInstruments = new ArrayList<IInstrument>(this.instruments.values());
        tempInstruments.sort((a, b) -> a.getStartLevel() - b.getStartLevel());
        for (IInstrument iInstrument : tempInstruments) {
            this.buildStartList(this.startList, (StandardInstrument)iInstrument);
        }
        for (StandardInstrument standardInstrument : this.startList) {
            this.start(standardInstrument);
        }
        for (StandardInstrument standardInstrument : this.startList) {
            standardInstrument.triggerStarted();
        }
        this.lifecycleDispatcher.start();
        this.dispatcher.triggerEvent((Event)new StartedEvent((Object)this));
    }

    protected void start(StandardInstrument instrument) {
        if (this.isFailed(instrument) || this.isStarted(instrument)) {
            return;
        }
        try {
            instrument.start();
            this.startedInstruments.add(instrument);
        }
        catch (RuntimeException e) {
            this.failedInstruments.add(instrument);
            throw e;
        }
    }

    public void stop() {
        if (!this.started) {
            return;
        }
        this.dispatcher.triggerEvent((Event)new IInstrumentRegistry.AboutToStopEvent(this));
        this.lifecycleDispatcher.stop();
        ReverseListIterator it = new ReverseListIterator(this.startList);
        while (it.hasNext()) {
            StandardInstrument instrument = (StandardInstrument)it.next();
            this.stop(instrument);
        }
        this.startList.clear();
        this.instruments.clear();
        this.started = false;
        this.dispatcher.triggerEvent((Event)new StoppedEvent((Object)this));
    }

    protected void stop(StandardInstrument instrument) {
        if (this.isFailed(instrument) || !this.isStarted(instrument)) {
            return;
        }
        try {
            instrument.stop();
            this.startedInstruments.remove(instrument);
        }
        catch (RuntimeException e) {
            Reporter.get().reportError(Msg.getString("StandardInstrumentRegistry.TitleError", new Object[0]), e.getMessage(), (Throwable)e, 0);
        }
    }

    public boolean stopRequested(Set visited) {
        if (visited != null) {
            if (visited.contains(this)) {
                return true;
            }
            visited.add(this);
        }
        StopRequestedEvent event = new StopRequestedEvent((Object)this, visited);
        this.dispatcher.triggerEvent((Event)event);
        if (!this.lifecycleDispatcher.stopRequested(visited)) {
            event.veto();
        }
        return !event.isVetoed();
    }

    protected void unregisterExtensionPoint(IExtensionPoint extensionPoint) throws InstrumentRegistryException {
        if (extensionPoint.getInstaller() != null) {
            extensionPoint.getInstaller().uninstall();
        }
        this.extensionPoints.remove(extensionPoint.getId());
        Log.trace("unregistered {}", (Object)StringTools.safeString((Object)extensionPoint));
    }

    @Override
    public void unregisterInstrument(IInstrument instrument) {
        if (instrument != null) {
            this.ppUndefine(instrument.getId());
            this.instruments.remove(instrument.getId());
        }
    }
}

