/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.claptz.impl;

import de.intarsys.claptz.IExtension;
import de.intarsys.claptz.IExtensionPoint;
import de.intarsys.claptz.IExtensionPointHandler;
import de.intarsys.claptz.InstrumentRegistryException;
import de.intarsys.claptz.impl.StandardExtension;
import de.intarsys.claptz.impl.StandardInstrument;
import de.intarsys.tools.attribute.AttributeMap;
import java.util.ArrayList;
import java.util.List;

public class StandardExtensionPoint
implements IExtensionPoint {
    public static final Object ATTR_EXTENSIONS = new Object();
    private final AttributeMap attributes = new AttributeMap();
    private List<IExtension> extensions = new ArrayList<IExtension>();
    private final String id;
    private IExtensionPointHandler installer;
    private final StandardInstrument provider;

    public StandardExtensionPoint(StandardInstrument instrument, String id) {
        this.provider = instrument;
        this.id = id;
    }

    public Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    @Override
    public List<IExtension> getExtensions() {
        return this.extensions;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IExtensionPointHandler getInstaller() {
        return this.installer;
    }

    @Override
    public StandardInstrument getProvider() {
        return this.provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerExtension(StandardExtension extension) throws InstrumentRegistryException {
        StandardExtensionPoint standardExtensionPoint = this;
        synchronized (standardExtensionPoint) {
            this.extensions.add(extension);
            extension.setExtensionPoint(this);
        }
        if (this.getInstaller() != null && this.getInstaller().isInstalled()) {
            this.getInstaller().install(extension);
        }
    }

    public Object removeAttribute(Object key) {
        return this.attributes.remove(key);
    }

    public Object setAttribute(Object key, Object value) {
        return this.attributes.put(key, value);
    }

    public void setInstaller(IExtensionPointHandler installer) {
        this.installer = installer;
    }

    public String toString() {
        try {
            return "IExtensionPoint '" + this.getId() + "' by " + this.getProvider();
        }
        catch (RuntimeException e) {
            return "<unprintable extension point>";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterExtension(StandardExtension extension) throws InstrumentRegistryException {
        StandardExtensionPoint standardExtensionPoint = this;
        synchronized (standardExtensionPoint) {
            this.extensions.remove(extension);
        }
        if (this.getInstaller() != null && this.getInstaller().isInstalled()) {
            this.getInstaller().uninstall(extension);
        }
    }
}

