/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.claptz.extension.runtime;

import de.intarsys.claptz.IExtension;
import de.intarsys.claptz.impl.ExtensionPointHandlerAdapter;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.objectmodel.FunctorMethod;
import de.intarsys.tools.objectmodel.IClass;
import de.intarsys.tools.objectmodel.IClassSelector;
import de.intarsys.tools.objectmodel.IMethod;
import de.intarsys.tools.objectmodel.ObjectModelTools;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class ObjectModelInstaller
extends ExtensionPointHandlerAdapter {
    private static final Logger Log = LoggerFactory.getLogger(ObjectModelInstaller.class);
    public static final String XA_IMPLEMENTOR = "implementor";
    public static final String XA_MODIFIERS = "modifiers";
    public static final String XA_NAME = "name";
    public static final String XE_METHOD = "method";
    public static final String XE_CLASS = "class";

    @Override
    protected Object basicInstallInsert(IExtension extension, IElement element) {
        if (XE_CLASS.equals(element.getName())) {
            String implementor = "";
            try {
                implementor = element.attributeValue(XA_IMPLEMENTOR, null);
                IClassSelector selector = ObjectModelTools.createSelector((String)implementor);
                IClass clazz = ObjectModelTools.registerClass((IClassSelector)selector);
                Iterator it = element.elementIterator("alias");
                while (it.hasNext()) {
                    IElement aliasElement = (IElement)it.next();
                    String aliasId = aliasElement.attributeValue("id", null);
                    IClassSelector aliasSelector = ObjectModelTools.createSelector((String)aliasId);
                    ObjectModelTools.registerClass((IClassSelector)aliasSelector, (IClass)clazz);
                }
            }
            catch (Exception e) {
                String msg = "error installing extension";
                this.log(Log, Level.ERROR, extension, element, msg, e);
            }
        } else if (XE_METHOD.equals(element.getName())) {
            String implementor = "";
            String methodname = "";
            String modifiers = null;
            try {
                IFunctor functor = ElementTools.createFunctor((Object)extension.getProvider(), (IElement)element, null, (Object)extension.getProvider());
                if (functor == null) {
                    String msg = "missing functor declaration";
                    this.log(Log, Level.ERROR, extension, element, msg, null);
                    return null;
                }
                implementor = element.attributeValue(XA_IMPLEMENTOR, null);
                methodname = element.attributeValue(XA_NAME, null);
                modifiers = element.attributeValue(XA_MODIFIERS, null);
                IClassSelector selector = ObjectModelTools.createSelector((String)implementor);
                FunctorMethod method = new FunctorMethod(methodname, functor);
                method.setModifiers(modifiers);
                method.setDeclaringClass(ObjectModelTools.lookupClass((IClassSelector)selector));
                ObjectModelTools.registerMethod((IClassSelector)selector, (IMethod)method);
            }
            catch (Exception e) {
                String msg = "error installing extension";
                this.log(Log, Level.ERROR, extension, element, msg, e);
            }
        } else {
            return super.basicInstallInsert(extension, element);
        }
        return null;
    }
}

