/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.cli;

import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.cli.CLICommandlineParser;
import de.intarsys.tools.cli.CLIException;
import de.intarsys.tools.cli.CLIOption;
import de.intarsys.tools.cli.CLIOptionDescriptorRegistry;
import de.intarsys.tools.cli.ICLIArgProcessor;
import de.intarsys.tools.cli.ICLICommandline;
import de.intarsys.tools.cli.ICLIOption;
import de.intarsys.tools.cli.ICLIOptionDescriptor;
import de.intarsys.tools.cli.ICLIOptionProcessor;
import de.intarsys.tools.cli.ICLIProcessor;
import de.intarsys.tools.cli.ICLIProcessorClient;
import de.intarsys.tools.cli.PACKAGE;
import de.intarsys.tools.component.IReferenceCounter;
import de.intarsys.tools.component.Singleton;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.monitor.IMonitor;
import de.intarsys.tools.monitor.MonitorTools;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

@Singleton
public class CLIProcessor
implements ICLIProcessor {
    private static final Logger Log = LoggerFactory.getLogger(CLIProcessor.class);
    private static final ThreadLocal<ICLIProcessor> ACTIVE = new ThreadLocal();
    private static final String MONITOR_ID = "de.intarsys.cli";
    private static final IMessageBundle Msg = PACKAGE.Messages;
    public static final int RC_DEFAULT = 0;
    private final Map<Object, Object> data = new HashMap<Object, Object>();
    private final AttributeMap attributes = new AttributeMap();
    private EventDispatcher dispatcher;
    private Exception exception;
    private ICLIOption mainOption = null;
    private ICLIOptionProcessor mainOptionProcessor = null;
    private IMonitor monitor;
    private Deque<Object> operands = new ArrayDeque<Object>();
    private Object result;
    private int resultCode = 0;
    private String resultMessage = "";
    private Deque<Deque<Object>> stacks = new ArrayDeque<Deque<Object>>();

    public static ICLIProcessor getActive() {
        return ACTIVE.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int processCommandLine(ICLICommandline commandline, ICLIProcessorClient client) {
        CLIProcessor processor = new CLIProcessor();
        try {
            ICLIOptionDescriptor[] optionDescriptors = CLIOptionDescriptorRegistry.get().getOptionDescriptors();
            processor.processCommandLine(commandline, optionDescriptors);
            int resultCode = processor.getResultCode();
            String resultMessage = processor.getResultMessage();
            Log.info("CLI OK " + resultCode + ": '" + resultMessage + "' (" + commandline + ")");
            while (!processor.isEmpty()) {
                Object operand = processor.peek();
                try {
                    client.processCommandlineRemainingOperand(operand);
                }
                finally {
                    processor.pop();
                }
            }
        }
        catch (CLIException e) {
            String resultMessage;
            int resultCode = processor.getResultCode();
            if (processor.getResultCode() == 0) {
                processor.setResultCode(-2);
            }
            if ((resultMessage = processor.getResultMessage()) == null || resultMessage.length() == 0) {
                resultMessage = e.getMessage();
                processor.setResultMessage(resultMessage);
            }
            Log.error("CLI ERROR " + resultCode + ": '" + resultMessage + "' (" + commandline + ")", (Throwable)e);
        }
        catch (RuntimeException e) {
            processor.setResultCode(-3);
            int resultCode = processor.getResultCode();
            String resultMessage = processor.getResultMessage();
            if (resultMessage == null || resultMessage.length() == 0) {
                resultMessage = e.getMessage();
                processor.setResultMessage(resultMessage);
            }
            Log.error("CLI UNEXPECTEDERROR " + resultCode + ": '" + resultMessage + "' (" + commandline + ")", (Throwable)e);
        }
        finally {
            client.cleanupLicenseAttributes(processor);
        }
        return processor.getResultCode();
    }

    public CLIProcessor() {
        this.monitor = MonitorTools.getMonitor((String)MONITOR_ID);
    }

    public <T extends Event> void addNotificationListener(EventType<? extends T> type, INotificationListener<T> listener) {
        if (this.dispatcher == null) {
            this.dispatcher = new EventDispatcher((Object)this);
        }
        this.dispatcher.addNotificationListener(type, listener);
    }

    public void clearData() {
        this.data.clear();
    }

    @Override
    public void freeOperands() {
        Deque<Object> oldOperands = this.operands;
        Deque<Object> prevStack = this.stacks.pop();
        this.operands = prevStack;
        while (!this.isEmpty()) {
            this.pop();
        }
        this.operands = oldOperands;
    }

    protected ICLIOptionDescriptor getArgumentProcessor(ICLIOptionDescriptor[] descriptors, String arg) {
        for (int i = 0; i < descriptors.length; ++i) {
            ICLIOptionDescriptor descriptor = descriptors[i];
            if (!(descriptor instanceof ICLIArgProcessor) || !((ICLIArgProcessor)((Object)descriptor)).canProcessArgument(arg)) continue;
            return descriptor;
        }
        return null;
    }

    public final Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    @Override
    public final Object getData(Object key) {
        return this.data.get(key);
    }

    public Exception getException() {
        return this.exception;
    }

    @Override
    public Object[] getOperands() {
        return this.operands.toArray();
    }

    protected ICLIOptionDescriptor getOptionDescriptor(ICLIOptionDescriptor[] descriptors, ICLIOption option) {
        for (int i = 0; i < descriptors.length; ++i) {
            ICLIOptionDescriptor descriptor = descriptors[i];
            if (!descriptor.getOpt().equals(option.getShortName()) && (descriptor.getLongOpt() == null || !descriptor.getLongOpt().equals(option.getLongName()))) continue;
            return descriptor;
        }
        return null;
    }

    public Object getResult() {
        return this.result;
    }

    @Override
    public int getResultCode() {
        return this.resultCode;
    }

    @Override
    public String getResultMessage() {
        return this.resultMessage;
    }

    @Override
    public boolean isEmpty() {
        return this.operands.isEmpty();
    }

    @Override
    public Object peek() {
        return this.operands.peek();
    }

    @Override
    public Object pop() {
        Object operand = this.operands.pop();
        if (operand instanceof IReferenceCounter) {
            ((IReferenceCounter)operand).release(null);
        }
        return operand;
    }

    public void processCommandLine(ICLICommandline cl, ICLIOptionDescriptor[] descriptors) throws CLIException {
        this.setResultCode(0);
        this.setResultMessage("");
        String[] args = cl.getRemainingArgs();
        if (cl.getOptions().length == 0 && args.length == 0) {
            return;
        }
        this.monitor.attach();
        ACTIVE.set(this);
        ICLIOption option = null;
        try {
            if (args.length > 0) {
                String filename = args[0].replace("\"", "");
                ICLIOptionDescriptor descriptor = this.getArgumentProcessor(descriptors, filename);
                if (descriptor == null) {
                    this.setResultCode(-1);
                    this.setResultMessage(Msg.getString("CLIProcessor.error.InvalidArgument", new Object[]{filename}));
                    throw new CLIException(this.getResultMessage());
                }
                CLIOption tempOption = new CLIOption("arg", "arg");
                tempOption.addValue(filename);
                option = tempOption;
                this.processOption(descriptor, option);
                cl.setProcessed(true);
            }
            ICLIOption[] options = cl.getOptions();
            for (int i = 0; i < options.length; ++i) {
                option = options[i];
                if (option.isProcessed()) {
                    this.processOption(null, null);
                    continue;
                }
                ICLIOptionDescriptor descriptor = null;
                descriptor = this.getOptionDescriptor(descriptors, option);
                if (descriptor == null) {
                    this.processOption(null, null);
                    this.setResultCode(-4);
                    this.setResultMessage("invalid commandline option '" + option + "'");
                    throw new CLIException(this.getResultMessage());
                }
                this.processOption(descriptor, option);
            }
            this.processOption(null, null);
        }
        catch (CLIException e) {
            this.mainOption = null;
            this.mainOptionProcessor = null;
            throw e;
        }
        catch (Exception e) {
            this.mainOption = null;
            this.mainOptionProcessor = null;
            throw new CLIException("exception processing commandline option " + option + " (" + e.getMessage() + "'", e);
        }
        finally {
            ACTIVE.remove();
            this.monitor.detach();
        }
    }

    @Override
    public void processCommandLine(String[] args, ICLIOptionDescriptor[] descriptors) throws CLIException {
        if (Log.isEnabledForLevel(Level.DEBUG)) {
            Log.debug("processing command line args");
            for (int i = 0; i < args.length; ++i) {
                Log.debug("    " + args[i]);
            }
        }
        CLICommandlineParser parser = new CLICommandlineParser();
        ICLICommandline commandline = parser.parse(args);
        this.processCommandLine(commandline, descriptors);
    }

    protected void processOption(ICLIOptionDescriptor descriptor, ICLIOption option) throws CLIException {
        ICLIOptionProcessor optionProcessor;
        ICLIOptionProcessor iCLIOptionProcessor = optionProcessor = descriptor == null ? null : descriptor.getOptionProcessor();
        if (descriptor == null || descriptor.isMainOption()) {
            if (this.mainOptionProcessor != null) {
                this.mainOptionProcessor.processOption(this, this.mainOption);
            }
            this.clearData();
            this.mainOptionProcessor = optionProcessor;
            this.mainOption = option;
        }
        if (optionProcessor == null) {
            return;
        }
        optionProcessor.initOption(this, option);
        if (!descriptor.isMainOption()) {
            optionProcessor.processOption(this, option);
        }
    }

    @Override
    public void push(Object operand) {
        if (operand instanceof IReferenceCounter) {
            ((IReferenceCounter)operand).acquire();
        }
        this.operands.push(operand);
    }

    public final Object removeAttribute(Object key) {
        return this.attributes.remove(key);
    }

    public <T extends Event> void removeNotificationListener(EventType<? extends T> type, INotificationListener<T> listener) {
        if (this.dispatcher == null) {
            return;
        }
        this.dispatcher.removeNotificationListener(type, listener);
    }

    @Override
    public void saveOperands() {
        Deque<Object> oldOperands = this.operands;
        this.stacks.push(oldOperands);
        this.operands = new ArrayDeque<Object>();
        for (Object object : oldOperands) {
            this.push(object);
        }
    }

    public final Object setAttribute(Object key, Object value) {
        return this.attributes.put(key, value);
    }

    @Override
    public final Object setData(Object key, Object value) {
        return this.data.put(key, value);
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    @Override
    public void setResultCode(int resultCode) {
        this.resultCode = resultCode;
    }

    @Override
    public void setResultMessage(String resultMessage) {
        this.resultMessage = resultMessage;
    }

    protected void triggerEvent(Event event) {
        if (this.dispatcher == null) {
            return;
        }
        this.dispatcher.triggerEvent(event);
    }
}

