/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingSslSocketFactory
extends SSLSocketFactory {
    private static final Logger Log = LoggerFactory.getLogger(DelegatingSslSocketFactory.class);
    private static List<String> DisabledCipherSuites = Collections.emptyList();
    private final SSLSocketFactory socketFactory;
    private String[] enabledProtocols;
    private String[] enabledCipherSuites;

    public static List<String> getDisabledCipherSuites() {
        return new ArrayList<String>(DisabledCipherSuites);
    }

    public static void setDisabledCipherSuites(List<String> value) {
        Log.info("SSL socket factory disable cipher suites " + value);
        DisabledCipherSuites = new ArrayList<String>(value);
    }

    public DelegatingSslSocketFactory(SSLSocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    @Override
    public Socket createSocket() throws IOException {
        Log.trace("SSL socket created");
        SSLSocket socket = (SSLSocket)this.getSocketFactory().createSocket();
        this.customizeSocket(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Log.trace("SSL socket to " + host + ":" + port + " created");
        SSLSocket socket = (SSLSocket)this.getSocketFactory().createSocket(host, port);
        this.customizeSocket(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        Log.trace("SSL socket to " + address.getHostName() + ":" + port + " created");
        SSLSocket socket = (SSLSocket)this.getSocketFactory().createSocket(address, port, localAddress, localPort);
        this.customizeSocket(socket);
        return socket;
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        Log.trace("SSL socket to " + host + ":" + port + " created");
        SSLSocket socket = (SSLSocket)this.getSocketFactory().createSocket(s, host, port, autoClose);
        this.customizeSocket(socket);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Log.trace("SSL socket to " + host + ":" + port + " created");
        SSLSocket socket = (SSLSocket)this.getSocketFactory().createSocket(host, port);
        this.customizeSocket(socket);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        Log.trace("SSL socket to " + host + ":" + port + " created");
        SSLSocket socket = (SSLSocket)this.getSocketFactory().createSocket(host, port, localHost, localPort);
        this.customizeSocket(socket);
        return socket;
    }

    protected void customizeSocket(SSLSocket socket) {
        if (this.enabledProtocols != null) {
            socket.setEnabledProtocols(this.getEnabledProtocols());
        }
        if (this.enabledCipherSuites != null) {
            socket.setEnabledCipherSuites(this.getEnabledCipherSuites());
        }
        socket.addHandshakeCompletedListener(new HandshakeCompletedListener(){

            @Override
            public void handshakeCompleted(HandshakeCompletedEvent event) {
                SSLSession session = event.getSession();
                String host = session.getPeerHost();
                int port = session.getPeerPort();
                Log.trace("SSL socket {}:{} connected", (Object)host, (Object)port);
                Log.trace("SSL socket {}:{} protocol {}", new Object[]{host, port, session.getProtocol()});
                Log.trace("SSL socket {}:{} ciphersuite {}", new Object[]{host, port, session.getCipherSuite()});
            }
        });
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.getSocketFactory().getDefaultCipherSuites();
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public SSLSocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.getSocketFactory().getSupportedCipherSuites();
    }

    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }
}

