/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.aaa.authenticate.impl;

import de.intarsys.aaa.authenticate.api.AuthenticationCanceled;
import de.intarsys.aaa.authenticate.api.AuthenticationException;
import de.intarsys.aaa.authenticate.api.AuthenticationTimeout;
import de.intarsys.aaa.authenticate.api.IAuthenticationContext;
import de.intarsys.aaa.authenticate.api.IAuthenticationEvidence;
import de.intarsys.aaa.authenticate.api.ICredential;
import de.intarsys.aaa.authenticate.api.RequestCredential;
import de.intarsys.aaa.authenticate.impl.CommonAuthenticationModule;
import de.intarsys.aaa.authenticate.impl.CommonAuthenticationState;
import de.intarsys.aaa.authenticate.impl.GenericAuthenticationEvidence;
import de.intarsys.aaa.authenticate.impl.GenericAuthenticationState;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.IReplyStage;
import de.intarsys.tools.conversation.impl.CancelStage;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.conversation.impl.ErrorStage;
import de.intarsys.tools.conversation.impl.ResultStage;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.zones.IZone;
import de.intarsys.tools.zones.Zone;
import java.security.Principal;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonAuthenticationContext
implements IAuthenticationContext {
    private static final Logger Log = LoggerFactory.getLogger(CommonAuthenticationContext.class);
    public static final String ARG_ERRORCODE = "errorCode";
    public static final String ARG_ERRORMESSAGE = "errorMessage";
    private Subject subject;
    private final CommonAuthenticationModule authenticationModule;
    private final Object authenticationMarker = new Object();
    private final IZone zone;
    private IAuthenticationEvidence evidence;
    private Principal principal;

    protected CommonAuthenticationContext(CommonAuthenticationModule authenticationModule, Subject subject) {
        this.authenticationModule = authenticationModule;
        this.subject = subject;
        this.zone = Zone.getCurrent();
    }

    @Override
    public final IConversation<Void> authenticate(IArgs authenticationArgs) {
        try {
            this.getZone().enter();
            Log.trace("{} authenticate", (Object)this);
            if (this.subject == null) {
                Log.trace("{} create a new subject", (Object)this);
                this.subject = this.createSubject();
            }
            if (this.isAuthenticated(this.subject)) {
                Log.trace("{} already authenticated, succeed", (Object)this);
                IConversation iConversation = Conversation.completed(null);
                return iConversation;
            }
            this.subjectReset();
            IConversation iConversation = this.basicAuthenticate(authenticationArgs).thenAccept(state -> this.subjectInstall((CommonAuthenticationState)state));
            return iConversation;
        }
        finally {
            this.getZone().leave();
        }
    }

    protected IConversation<CommonAuthenticationState> basicAuthenticate(IArgs authenticationArgs) {
        IConversation<CommonAuthenticationState> conversation = this.createConversation(authenticationArgs);
        if (!conversation.getReplyStage().isFinal()) {
            try {
                CommonAuthenticationState state = this.createState(conversation, authenticationArgs);
                IReplyStage stage = this.createReplyStage(authenticationArgs);
                if (stage instanceof ResultStage) {
                    conversation.complete((Object)((CommonAuthenticationState)((ResultStage)stage).getResult()));
                } else if (stage instanceof CancelStage) {
                    conversation.cancel(false);
                } else if (stage instanceof ErrorStage) {
                    conversation.completeExceptionally(((ErrorStage)stage).getThrowable());
                } else {
                    stage.onAck(ack -> this.verify(state, ack));
                }
                conversation.setReplyStage(stage);
            }
            catch (Exception e) {
                conversation.completeExceptionally((Throwable)e);
            }
        }
        return conversation;
    }

    protected CommonAuthenticationState basicCreateState(IConversation<CommonAuthenticationState> conversation, IArgs authenticationArgs) throws Exception {
        return new GenericAuthenticationState(this, (IConversation)conversation, authenticationArgs);
    }

    protected void basicDeauthenticate() {
    }

    protected void basicVerify(CommonAuthenticationState state, ICredential credential) throws AuthenticationException {
        if (this.getAuthenticationModule().getCredentialVerifier() != null) {
            this.getAuthenticationModule().getCredentialVerifier().verify(state, credential);
        }
    }

    protected void basicVerify(CommonAuthenticationState state, Object ack) {
        try {
            ICredential credential = this.convertToCredential(ack);
            if (credential == null) {
                throw new AuthenticationCanceled();
            }
            this.basicVerify(state, credential);
            state.getArgs().put(ARG_ERRORCODE, null);
            state.getArgs().put(ARG_ERRORMESSAGE, null);
            state.setCredential(credential);
            state.getConversation().complete((Object)state);
        }
        catch (AuthenticationCanceled e) {
            state.getArgs().put(ARG_ERRORCODE, (Object)"authentication_canceled");
            state.getArgs().put(ARG_ERRORMESSAGE, (Object)ExceptionTools.getMessage((Throwable)e));
            state.getConversation().cancel(false);
        }
        catch (AuthenticationTimeout e) {
            state.getArgs().put(ARG_ERRORCODE, (Object)"authentication_timeout");
            state.getArgs().put(ARG_ERRORMESSAGE, (Object)ExceptionTools.getMessage((Throwable)e));
            state.getConversation().completeExceptionally((Throwable)e);
        }
        catch (AuthenticationException e) {
            state.getArgs().put(ARG_ERRORCODE, (Object)"authentication_failed");
            state.getArgs().put(ARG_ERRORMESSAGE, (Object)ExceptionTools.getMessage((Throwable)e));
            if (!this.isRetry()) {
                state.getConversation().completeExceptionally((Throwable)e);
            }
        }
        catch (Exception e) {
            state.getArgs().put(ARG_ERRORCODE, (Object)"authentication_failed");
            state.getArgs().put(ARG_ERRORMESSAGE, (Object)ExceptionTools.getMessage((Throwable)e));
            state.getConversation().completeExceptionally((Throwable)e);
        }
    }

    protected ICredential convertToCredential(Object ack) throws AuthenticationException {
        if (ack == null) {
            return null;
        }
        if (!(ack instanceof ICredential)) {
            throw new IllegalArgumentException("credential required");
        }
        return (ICredential)ack;
    }

    protected IAuthenticationEvidence createAuthenticationEvidence(CommonAuthenticationState authenticationState) {
        return new GenericAuthenticationEvidence(authenticationState);
    }

    protected IConversation<CommonAuthenticationState> createConversation(IArgs authenticationArgs) {
        return new Conversation("authentication-" + this.getAuthenticationModule().getId());
    }

    protected Principal createPrincipal(CommonAuthenticationState state) throws Exception {
        if (this.getAuthenticationModule().getPrincipalFactory() != null) {
            return this.getAuthenticationModule().getPrincipalFactory().createPrincipal(state);
        }
        return null;
    }

    protected IReplyStage createReplyStage(IArgs authenticationArgs) {
        return new RequestCredential(this.getAuthenticationModule().getCredentialSpec());
    }

    protected final CommonAuthenticationState createState(IConversation<CommonAuthenticationState> conversation, IArgs authenticationArgs) throws Exception {
        CommonAuthenticationState state = this.basicCreateState(conversation, authenticationArgs);
        CommonAuthenticationState.setAuthState(conversation, state);
        return state;
    }

    protected Subject createSubject() {
        return new Subject();
    }

    @Override
    public final void deauthenticate() {
        try {
            this.getZone().enter();
            this.basicDeauthenticate();
            if (this.getSubject() != null) {
                if (this.getPrincipal() != null) {
                    this.getSubject().getPrincipals().remove(this.getPrincipal());
                }
                this.setSubject(null);
            }
            if (this.getPrincipal() != null) {
                this.setPrincipal(null);
            }
            this.evidence = null;
        }
        finally {
            this.getZone().leave();
        }
    }

    public CommonAuthenticationModule getAuthenticationModule() {
        return this.authenticationModule;
    }

    protected Principal getPrincipal() {
        return this.principal;
    }

    @Override
    public Subject getSubject() {
        return this.subject;
    }

    protected IZone getZone() {
        return this.zone;
    }

    protected boolean isAuthenticated(Subject subject) {
        for (Object current : subject.getPrivateCredentials()) {
            if (current != this.authenticationMarker) continue;
            return true;
        }
        return false;
    }

    protected boolean isRetry() {
        return false;
    }

    protected void setPrincipal(Principal principal) {
        this.principal = principal;
    }

    protected void setSubject(Subject subject) {
        this.subject = subject;
    }

    protected void subjectInstall(CommonAuthenticationState state) throws Exception {
        this.principal = this.createPrincipal(state);
        if (this.principal != null) {
            this.getSubject().getPrincipals().add(this.principal);
        }
        this.evidence = this.createAuthenticationEvidence(state);
        if (this.getAuthenticationModule().isCached()) {
            this.getSubject().getPrivateCredentials().add(this.authenticationMarker);
        }
        if (this.evidence != null) {
            this.getSubject().getPublicCredentials().add(this.evidence);
        }
    }

    protected void subjectReset() {
        this.getSubject().getPrivateCredentials().remove(this.authenticationMarker);
        if (this.evidence != null) {
            this.getSubject().getPublicCredentials().remove(this.evidence);
        }
    }

    public final void verify(CommonAuthenticationState state, Object ack) {
        try {
            this.getZone().enter();
            this.basicVerify(state, ack);
        }
        finally {
            this.getZone().leave();
        }
    }
}

