/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging.logback;

import de.intarsys.tools.logging.logback.LogbackFilter;

public class ThreadFilter
extends LogbackFilter {
    private ThreadLocal<Integer> threadActivation = ThreadLocal.withInitial(() -> 0);

    public ThreadFilter(boolean activate) {
        if (activate) {
            this.activate();
        }
    }

    public boolean activate() {
        int tempActivation = this.threadActivation.get();
        this.threadActivation.set(tempActivation + 1);
        return tempActivation == 0;
    }

    public boolean deactivate() {
        int tempActivation = this.threadActivation.get();
        this.threadActivation.set(tempActivation - 1);
        return tempActivation == 1;
    }

    public boolean isActive() {
        return this.threadActivation.get() > 0;
    }

    @Override
    public boolean isLoggable(Object event) {
        return this.threadActivation.get() > 0;
    }
}

