/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import de.intarsys.tools.enumeration.EnumMeta;
import de.intarsys.tools.logging.EnumLogLevel;
import de.intarsys.tools.logging.ILoggingEnvironment;
import de.intarsys.tools.logging.logback.LogbackTools;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.IPreferencesSupport;
import de.intarsys.tools.preferences.IPreferencesSyncher;
import de.intarsys.tools.preferences.PreferencesFactory;
import de.intarsys.tools.preferences.PreferencesTools;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.util.List;

public class LogbackLoggingEnvironment
implements IPreferencesSupport,
IPreferencesSyncher,
ILoggingEnvironment {
    public static final String PREF_LOGLEVEL = "logLevel";
    private IPreferences preferences;

    protected IPreferences createPreferences() {
        IPreferences result = PreferencesFactory.get().getMain().node(this.getPreferencesName());
        return result;
    }

    public File getLogDirectory() {
        return LogbackTools.getLogDirectory();
    }

    public List<File> getLogFiles() {
        return LogbackTools.getLogFiles();
    }

    public EnumLogLevel getLogLevel() {
        return (EnumLogLevel)PreferencesTools.getEnumItem((IPreferences)this.getPreferences(), (EnumMeta)EnumLogLevel.META, (String)PREF_LOGLEVEL);
    }

    public EnumMeta<EnumLogLevel> getLogLevelDomain() {
        return EnumLogLevel.META;
    }

    public IPreferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = this.createPreferences();
        }
        return this.preferences;
    }

    public String getPreferencesName() {
        return "logging";
    }

    @PostConstruct
    public void install() {
        this.preferencesRestore();
    }

    public void preferencesRestore() {
        this.preferencesRestore(this.getPreferences());
    }

    protected void preferencesRestore(IPreferences preferences) {
        Logger rootLogger;
        String levelName = preferences.get(PREF_LOGLEVEL, "OFF");
        Level logLevel = LogbackTools.toLevel(levelName, Level.OFF);
        if (logLevel != Level.OFF && (rootLogger = LogbackTools.getRootLogger()).getLevel() != logLevel) {
            rootLogger.setLevel(logLevel);
        }
    }

    public void preferencesStore() {
        this.preferencesStore(this.getPreferences());
    }

    protected void preferencesStore(IPreferences preferences) {
    }

    public void setLogLevel(EnumLogLevel logLevel) {
        this.getPreferences().put(PREF_LOGLEVEL, logLevel.getId());
        this.preferencesRestore();
    }
}

