/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.suis.validator.rest.to.response;

import ch.admin.suis.validator.rest.to.SignatureTO;
import ch.admin.suis.validator.rest.to.ValidationData;
import com.fasterxml.jackson.annotation.JsonIgnore;
import de.intarsys.tools.hex.HexTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ValidatableFile {
    private byte[] documentHash;
    private String documentName;
    private String mainClient;
    private List<SignatureTO> signatures;
    private ValidationData validationData;
    private int mdpPermission;

    public String getClient() {
        return this.mainClient;
    }

    public byte[] getDocumentHash() {
        return this.documentHash;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    @Deprecated
    @JsonIgnore
    public String getMandant() {
        return this.getClient();
    }

    public int getMdpPermission() {
        return this.mdpPermission;
    }

    public List<SignatureTO> getSignatures() {
        if (this.signatures == null) {
            this.signatures = new ArrayList<SignatureTO>();
        }
        return this.signatures;
    }

    public ValidationData getValidationData() {
        return this.validationData;
    }

    public void setClient(String client) {
        this.mainClient = client;
    }

    public void setDocumentHash(byte[] documentHash) {
        this.documentHash = (byte[])(documentHash != null ? Arrays.copyOf(documentHash, documentHash.length) : null);
    }

    public void setDocumentName(String documentName) {
        this.documentName = documentName;
    }

    @Deprecated
    public void setMandant(String mandant) {
        this.setClient(mandant);
    }

    public void setMdpPermission(int mdpPermission) {
        this.mdpPermission = mdpPermission;
    }

    public void setSignatures(List<SignatureTO> signatures) {
        this.signatures = signatures;
    }

    public void setValidationData(ValidationData validationData) {
        this.validationData = validationData;
    }

    public String toString() {
        String value = "ValidatableFile document name=" + this.documentName + " , hash=" + HexTools.bytesToHexString((byte[])this.documentHash).toLowerCase() + ", client[s]=";
        StringBuffer clients = new StringBuffer();
        if (this.signatures != null) {
            for (SignatureTO signatureTO : this.signatures) {
                clients.append(signatureTO.getClient()).append(' ');
            }
        }
        return value + clients;
    }
}

