/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.suis.validator.rest.to.response;

import ch.admin.suis.validator.rest.to.OverallMandatorStatus;
import ch.admin.suis.validator.rest.to.StatusUtil;
import ch.admin.suis.validator.rest.to.ValidStatus;
import ch.admin.suis.validator.rest.to.response.SignatureCoverageStatus;
import ch.admin.suis.validator.rest.to.response.SignatureReport;
import de.intarsys.tools.hex.HexTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FileReport {
    private boolean docModifiedAfterLastSignature;
    private byte[] documentHash;
    private String documentName;
    private String mandator;
    private OverallMandatorStatus mandatorRequirements;
    private SignatureCoverageStatus signatureCoverageStatus;
    private List<SignatureReport> signatureReports;

    public byte[] getDocumentHash() {
        return this.documentHash;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public String getMandator() {
        return this.mandator;
    }

    public OverallMandatorStatus getMandatorRequirements() {
        return this.mandatorRequirements;
    }

    public SignatureCoverageStatus getSignatureCoverageStatus() {
        return this.signatureCoverageStatus;
    }

    public List<SignatureReport> getSignatureReports() {
        if (this.signatureReports == null) {
            this.signatureReports = new ArrayList<SignatureReport>();
        }
        return this.signatureReports;
    }

    public boolean isDocModifiedAfterLastSignature() {
        return this.docModifiedAfterLastSignature;
    }

    private boolean isDocModifiedInvalid() {
        return this.signatureCoverageStatus != null && this.signatureCoverageStatus == SignatureCoverageStatus.MODIFIED_INVALID;
    }

    public ValidStatus isValid() {
        if (this.isDocModifiedAfterLastSignature() && this.isDocModifiedInvalid() || this.mandatorRequirementsNotMet()) {
            return ValidStatus.INVALID;
        }
        List<SignatureReport> reports = this.getSignatureReports();
        ValidStatus state = StatusUtil.initStatusSig(reports);
        for (SignatureReport sigRep : reports) {
            state = StatusUtil.updateStatus(state, sigRep.isValid());
        }
        return state;
    }

    public ValidStatus isValidCert() {
        List<SignatureReport> reports = this.getSignatureReports();
        ValidStatus state = StatusUtil.initStatusSig(reports);
        for (SignatureReport sigRep : reports) {
            state = StatusUtil.updateStatus(state, sigRep.isValidCert());
        }
        return state;
    }

    public ValidStatus isValidMandant() {
        List<SignatureReport> reports = this.getSignatureReports();
        ValidStatus state = StatusUtil.initStatusSig(reports);
        for (SignatureReport sigRep : reports) {
            state = StatusUtil.updateStatus(state, sigRep.isValidMandant());
        }
        return state;
    }

    public ValidStatus isValidRevoc() {
        List<SignatureReport> reports = this.getSignatureReports();
        ValidStatus state = StatusUtil.initStatusSig(reports);
        for (SignatureReport sigRep : reports) {
            state = StatusUtil.updateStatus(state, sigRep.isValidRevoc());
        }
        return state;
    }

    public ValidStatus isValidSig() {
        List<SignatureReport> reports = this.getSignatureReports();
        ValidStatus state = StatusUtil.initStatusSig(reports);
        for (SignatureReport sigRep : reports) {
            state = StatusUtil.updateStatus(state, sigRep.isValidSig());
        }
        return state;
    }

    public ValidStatus isValidTimestamp() {
        List<SignatureReport> reports = this.getSignatureReports();
        ValidStatus state = StatusUtil.initStatusSig(reports);
        for (SignatureReport sigRep : reports) {
            state = StatusUtil.updateStatus(state, sigRep.isValidTimestamp());
        }
        return state;
    }

    public boolean mandatorRequirementsNotMet() {
        return this.mandatorRequirements != null && ValidStatus.INVALID == this.mandatorRequirements.isValid();
    }

    public void setDocModifiedAfterLastSignature(boolean docModifiedAfterLastSignature) {
        this.docModifiedAfterLastSignature = docModifiedAfterLastSignature;
    }

    public void setDocumentHash(byte[] documentHash) {
        this.documentHash = (byte[])(documentHash != null ? Arrays.copyOf(documentHash, documentHash.length) : null);
    }

    public void setDocumentName(String documentName) {
        this.documentName = documentName;
    }

    public void setMandator(String mandator) {
        this.mandator = mandator;
    }

    public void setMandatorRequirements(OverallMandatorStatus mandatorRequirements) {
        this.mandatorRequirements = mandatorRequirements;
    }

    public void setSignatureCoverageStatus(SignatureCoverageStatus signatureCoverageStatus) {
        this.signatureCoverageStatus = signatureCoverageStatus;
    }

    public void setSignatureReports(List<SignatureReport> signatureReports) {
        this.signatureReports = signatureReports;
    }

    public String toString() {
        return "FileReport for Document name=" + this.documentName + ", hash=" + HexTools.bytesToHexString((byte[])this.documentHash).toLowerCase() + ", mandator=" + this.mandator;
    }
}

