/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.validation;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.asn1.cms.SignerIdentifier;
import de.intarsys.asn1.cms.SignerInfo;
import de.intarsys.asn1.x509.Certificate;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.X509CertificateFactory;
import de.intarsys.security.method.cms.validation.PACKAGE;
import de.intarsys.security.method.cms.validation.ValidationDataCollector;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignerInfoValidationDataCollector
extends ValidationDataCollector {
    private static final Logger Log = LoggerFactory.getLogger(SignerInfoValidationDataCollector.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private final CMS cms;
    private final SignerInfo signerInfo;

    public SignerInfoValidationDataCollector(SignerInfo signerInfo, CMS cms) {
        this.signerInfo = signerInfo;
        this.cms = cms;
    }

    @Override
    protected List<IX509Certificate> getAdditionalCertificates() throws IOException {
        ArrayList<IX509Certificate> result = new ArrayList<IX509Certificate>();
        for (Certificate cert : this.cms.getSignedData().getCertificates().getAllExcept(this.signerInfo.getSid())) {
            try {
                result.add((IX509Certificate)X509CertificateFactory.get().createPublicKeyCertificate(cert.getDEREncoded()));
            }
            catch (CertificateException e) {
                throw new IOException(e.getLocalizedMessage(), e);
            }
        }
        return result;
    }

    @Override
    protected IX509Certificate[] getAttributeCertificates() throws IOException {
        return new IX509Certificate[0];
    }

    @Override
    protected IX509Certificate[] getSignerCertificates() throws IOException {
        SignerIdentifier sid = this.signerInfo.getSid();
        Certificate cert = this.cms.getSignedData().getCertificates().getCertificate(sid);
        if (cert == null) {
            throw new IOException(Msg.getString("SignerInfoValidationDataCollector.ErrorNoCertificateFound", new Object[0]));
        }
        try {
            IX509PublicKeyCertificate signerCertificate = X509CertificateFactory.get().createPublicKeyCertificate(cert.getDEREncoded());
            return new IX509PublicKeyCertificate[]{signerCertificate};
        }
        catch (CertificateException e) {
            throw new IOException(e);
        }
    }
}

