/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.validation;

import de.intarsys.security.algorithm.common.AlgorithmSpec;
import de.intarsys.security.app.validation.CachingDigestProvider;
import de.intarsys.security.method.cms.signature.CMSBasedSignatureContainer;
import de.intarsys.security.method.cms.validation.NoReferenceDataProvidedException;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;

public class CMSBasedSignatureDigestProvider
extends CachingDigestProvider {
    private final CMSBasedSignatureContainer container;

    public CMSBasedSignatureDigestProvider(CMSBasedSignatureContainer container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IDigest basicDigest(AlgorithmSpec algorithmSpec) throws NoSuchAlgorithmException, IOException {
        IDigester digester = DigestTools.createDigester((String)algorithmSpec.getAlgorithm().getCanonicalName());
        ILocator ref = this.getSignedContentLocator();
        if (ref == null || !ref.exists()) {
            throw new NoReferenceDataProvidedException();
        }
        InputStream in = null;
        try {
            in = ref.getInputStream();
            IDigest iDigest = DigestTools.digest((IDigester)digester, (InputStream)in);
            return iDigest;
        }
        finally {
            StreamTools.close((Closeable)in);
        }
    }

    private ILocator getSignedContentLocator() {
        return this.container.getSignedContentLocator();
    }
}

