/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.signature;

import de.intarsys.asn1.cms.OCSPRevocationInfo;
import de.intarsys.asn1.cms.OtherRevocationInfoFormat;
import de.intarsys.asn1.cms.RevocationInfoChoices;
import de.intarsys.asn1.x509.crl.CertificateList;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.crl.common.X509CRL;
import de.intarsys.security.ocsp.IOCSPResponse;
import de.intarsys.security.ocsp.common.OCSPResponse;
import java.io.IOException;
import java.security.cert.CRLException;
import java.util.ArrayList;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;

public class RevocationInfos {
    private final RevocationInfoChoices choices;

    public RevocationInfos(RevocationInfoChoices choices) {
        this.choices = choices;
    }

    public IX509CRL[] getCRLs() throws IOException {
        if (this.choices == null) {
            return new IX509CRL[0];
        }
        ArrayList<X509CRL> result = new ArrayList<X509CRL>();
        for (CertificateList certificateList : this.choices.getCertificateLists()) {
            try {
                result.add(new X509CRL(certificateList));
            }
            catch (CRLException e) {
                throw new IOException(e.getLocalizedMessage(), e);
            }
        }
        return result.toArray(new IX509CRL[result.size()]);
    }

    public IOCSPResponse[] getOCSPResponses() throws IOException {
        if (this.choices == null) {
            return new IOCSPResponse[0];
        }
        ArrayList<OCSPResponse> result = new ArrayList<OCSPResponse>();
        for (OtherRevocationInfoFormat otherRevocationInfoFormat : this.choices.getOtherRevocationInfo()) {
            OCSPRevocationInfo ocspRevocationInfo;
            org.bouncycastle.asn1.ocsp.OCSPResponse ocspResponse;
            if (!(otherRevocationInfoFormat instanceof OCSPRevocationInfo) || (ocspResponse = (ocspRevocationInfo = (OCSPRevocationInfo)otherRevocationInfoFormat).getOCSPResponse()).getResponseStatus().getValue().intValue() != 0) continue;
            byte[] encBasicOCSPResp = ocspResponse.getResponseBytes().getResponse().getOctets();
            result.add(new OCSPResponse(new BasicOCSPResp(BasicOCSPResponse.getInstance((Object)encBasicOCSPResp))));
        }
        return result.toArray(new IOCSPResponse[result.size()]);
    }
}

