/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.signature;

import de.intarsys.security.app.signature.ISignatureContainerEntryProcessor;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.app.timestamp.ITimestampCreator;
import de.intarsys.security.app.validation.IValidationDataCollector;
import de.intarsys.security.method.cms.attribute.encoder.AttributeCertificatesEncoder;
import de.intarsys.security.method.cms.attribute.encoder.SigningCertificateEncoder;
import de.intarsys.security.method.cms.attribute.encoder.SigningTimeEncoder;
import de.intarsys.security.method.cms.attribute.encoder.TimestampEncoder;
import de.intarsys.security.method.cms.signature.CommonCMSSignatureContainerBuilderFactory;
import de.intarsys.security.method.cms.signature.ICMSSignatureContainerBuilder;
import de.intarsys.security.method.cms.validation.CMSValidationDataExtender;
import de.intarsys.security.method.common.signature.AdESSignerTools;
import de.intarsys.security.signature.ValidationDataOptions;
import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.component.SingletonProvider;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.servicelocator.ServiceLocator;
import java.util.List;

@SingletonProvider
public class CMSSignatureContainerBuilderFactoryGeneric
extends CommonCMSSignatureContainerBuilderFactory {
    public static CMSSignatureContainerBuilderFactoryGeneric get() {
        return (CMSSignatureContainerBuilderFactoryGeneric)((Object)ServiceLocator.get().get(CMSSignatureContainerBuilderFactoryGeneric.class));
    }

    public String getLabel() {
        return "CMS";
    }

    @Override
    protected void prepareCMSSigner(ICMSSignatureContainerBuilder builder, IArgs args) throws ObjectCreationException {
        super.prepareCMSSigner(builder, args);
        builder.setIncludeCertificates(AdESSignerTools.isIncludeCertificates((IArgs)args));
        builder.addAttributeProvider(new SigningTimeEncoder());
        ITimestampCreator tsService = AdESSignerTools.createTimestampCreator((IArgs)args);
        builder.addAttributeProvider(new TimestampEncoder(tsService));
        List attrCerts = AdESSignerTools.getAttributeCertificates((IArgs)args);
        if (!attrCerts.isEmpty()) {
            builder.addAttributeProvider(new AttributeCertificatesEncoder(attrCerts));
        }
        builder.addAttributeProvider(new SigningCertificateEncoder());
        ISigner digestSigner = builder.getSigner();
        ValidationDataOptions options = AdESSignerTools.getValidationDataOptions((IArgs)args);
        if (options.isAddValidationData()) {
            CMSValidationDataExtender extender = new CMSValidationDataExtender();
            extender.setValidationDataOptions(options);
            extender.setFailOnError(false);
            extender.setValidationDataCollector(() -> (IValidationDataCollector)AdapterTools.getAdapter((Object)digestSigner, IValidationDataCollector.class, null));
            builder.addPostProcessor((ISignatureContainerEntryProcessor)extender);
        }
    }
}

