/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.signature;

import de.intarsys.security.app.signature.ISignatureContainerEntryProcessor;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.app.signature.SignatureContainerEntryReviewer;
import de.intarsys.security.app.timestamp.ITimestampCreator;
import de.intarsys.security.app.validation.IReviewer;
import de.intarsys.security.app.validation.IValidationDataCollector;
import de.intarsys.security.method.cms.attribute.encoder.CommitmentTypeIndicationEncoder;
import de.intarsys.security.method.cms.attribute.encoder.SignaturePolicyIdentifierEncoder;
import de.intarsys.security.method.cms.attribute.encoder.SignerAttributesV2Encoder;
import de.intarsys.security.method.cms.attribute.encoder.SigningCertificateEncoder;
import de.intarsys.security.method.cms.attribute.encoder.SigningTimeEncoder;
import de.intarsys.security.method.cms.attribute.encoder.TimestampEncoder;
import de.intarsys.security.method.cms.signature.CommonCMSSignatureContainerBuilderFactory;
import de.intarsys.security.method.cms.signature.ICMSSignatureContainerBuilder;
import de.intarsys.security.method.cms.validation.CMSValidationDataExtender;
import de.intarsys.security.method.common.signature.AdESEnvironment;
import de.intarsys.security.method.common.signature.AdESSignerTools;
import de.intarsys.security.signature.ValidationDataOptions;
import de.intarsys.security.signature.etsi.api.ConformanceLevel;
import de.intarsys.security.signature.etsi.api.SignatureFormat;
import de.intarsys.security.signature.etsi.service.SignatureCreationService;
import de.intarsys.security.signature.policy.ICommitmentTypeIndication;
import de.intarsys.security.signature.policy.IPolicyReference;
import de.intarsys.security.signature.policy.SignaturePolicyValidator;
import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.component.SingletonProvider;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.servicelocator.ServiceLocator;
import java.util.List;

@SingletonProvider
public class CMSSignatureContainerBuilderFactoryCAdES
extends CommonCMSSignatureContainerBuilderFactory {
    public static CMSSignatureContainerBuilderFactoryCAdES get() {
        return (CMSSignatureContainerBuilderFactoryCAdES)((Object)ServiceLocator.get().get(CMSSignatureContainerBuilderFactoryCAdES.class));
    }

    public String getLabel() {
        return "CAdES";
    }

    @Override
    protected void prepareCMSSigner(ICMSSignatureContainerBuilder builder, IArgs args) throws ObjectCreationException {
        List attrCerts;
        ConformanceLevel level;
        ICommitmentTypeIndication commitmentTypeIndication;
        super.prepareCMSSigner(builder, args);
        builder.setIncludeCertificates(AdESSignerTools.isIncludeCertificates((IArgs)args));
        builder.addAttributeProvider(new SigningCertificateEncoder());
        builder.addAttributeProvider(new SigningTimeEncoder());
        IPolicyReference signaturePolicy = AdESSignerTools.getSignaturePolicy((IArgs)args);
        if (signaturePolicy != null) {
            builder.addAttributeProvider(new SignaturePolicyIdentifierEncoder(signaturePolicy));
        }
        if ((commitmentTypeIndication = AdESSignerTools.getCommitmentTypeIndication((IArgs)args)) != null) {
            builder.addAttributeProvider(new CommitmentTypeIndicationEncoder(ListTools.with((Object[])new ICommitmentTypeIndication[]{commitmentTypeIndication})));
        }
        if ((level = SignatureCreationService.getConformanceLevel((IArgs)args, null)) == null || level.isTimestampRequired()) {
            boolean enforceTimestamp;
            ITimestampCreator tsService = AdESSignerTools.createTimestampCreator((IArgs)args);
            boolean bl = enforceTimestamp = level != null && level.isTimestampRequired();
            if (enforceTimestamp && tsService == null) {
                tsService = AdESEnvironment.get().createDefaultTimestampCreator();
            }
            TimestampEncoder timestampEncoder = new TimestampEncoder(tsService);
            timestampEncoder.setEnforceTimestamp(enforceTimestamp);
            builder.addAttributeProvider(timestampEncoder);
        }
        if (!(attrCerts = AdESSignerTools.getAttributeCertificates((IArgs)args)).isEmpty()) {
            builder.addAttributeProvider(new SignerAttributesV2Encoder(attrCerts));
        }
        ISigner digestSigner = builder.getSigner();
        ValidationDataOptions options = AdESSignerTools.getValidationDataOptions((IArgs)args);
        if (options.isAddValidationData()) {
            CMSValidationDataExtender extender = new CMSValidationDataExtender();
            extender.setValidationDataOptions(options);
            extender.setFailOnError(false);
            extender.setValidationDataCollector(() -> (IValidationDataCollector)AdapterTools.getAdapter((Object)digestSigner, IValidationDataCollector.class, null));
            builder.addPostProcessor((ISignatureContainerEntryProcessor)extender);
        }
        if (signaturePolicy != null) {
            IReviewer policyValidator = SignaturePolicyValidator.create((IPolicyReference)signaturePolicy);
            builder.addPostProcessor((ISignatureContainerEntryProcessor)new SignatureContainerEntryReviewer(policyValidator));
        }
    }

    @Override
    protected void prepareDigestSigner(ISigner signer, IArgs args) throws ObjectCreationException {
        super.prepareDigestSigner(signer, args);
        signer.setSignatureFormat(SignatureFormat.CAdES);
    }
}

