/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.signature;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.asn1.cms.CertificateSet;
import de.intarsys.asn1.cms.SignedData;
import de.intarsys.asn1.cms.SignerInfo;
import de.intarsys.asn1.cms.SignerInfos;
import de.intarsys.asn1.x509.Certificate;
import de.intarsys.asn1.x509.CommonCertificate;

public class CMSExtender {
    private final CMS cms;

    public CMSExtender(CMS cms) {
        this.cms = cms;
    }

    public void addSignatures(CMS source) {
        if (!source.isSignedData()) {
            throw new IllegalArgumentException("invalid cms content type: " + this.cms.getContentTypeId());
        }
        this.addSignatures(source.getSignedData(), this.getCms().getSignedData());
    }

    protected void addSignatures(SignedData source, SignedData target) {
        if (source == null || target == null) {
            return;
        }
        SignerInfos sourceSignerInfos = source.getSignerInfos();
        SignerInfos targetSignerInfos = target.getSignerInfos();
        for (int i = 0; i < sourceSignerInfos.size(); ++i) {
            SignerInfo signerInfo = sourceSignerInfos.get(i);
            targetSignerInfos.add(signerInfo);
        }
        CertificateSet sourceCertificates = source.getCertificates();
        CertificateSet targetCertificates = target.getCertificates();
        for (int i = 0; i < sourceCertificates.size(); ++i) {
            Certificate certificate = sourceCertificates.get(i);
            targetCertificates.add((CommonCertificate)certificate);
        }
        target.setCertificates(targetCertificates);
    }

    public CMS getCms() {
        return this.cms;
    }
}

