/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.encryption;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.asn1.cms.ContentEncryptionAlgorithmIdentifier;
import de.intarsys.asn1.cms.ContentType;
import de.intarsys.asn1.cms.EncryptedContent;
import de.intarsys.asn1.cms.EncryptedContentInfo;
import de.intarsys.asn1.cms.EncryptedData;
import de.intarsys.asn1.common.Version;
import de.intarsys.security.app.crypt.IEncryptedData;
import de.intarsys.security.app.encryption.IEncryptor;
import de.intarsys.security.method.cms.encryption.CommonPKCS7Encoder;
import de.intarsys.security.method.cms.encryption.EncryptorException;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;

public class PKCS7EncryptedDataEncoder
extends CommonPKCS7Encoder {
    private IEncryptor device;
    private ASN1ObjectIdentifier contentType;

    public PKCS7EncryptedDataEncoder(IEncryptor device) {
        this.device = device;
    }

    protected EncryptedContentInfo encrypt(ILocator locator) throws EncryptorException {
        IEncryptedData encryptedData = null;
        try {
            byte[] data = StreamTools.toByteArray((InputStream)locator.getInputStream());
            encryptedData = this.getDevice().encrypt(data);
        }
        catch (Exception e) {
            throw new EncryptorException(e);
        }
        EncryptedContentInfo encryptedContentInfo = (EncryptedContentInfo)EncryptedContentInfo.FACTORY.createNew();
        encryptedContentInfo.setContentType((ContentType)ContentType.FACTORY.create((ASN1Encodable)this.getContentType()));
        encryptedContentInfo.setContentEncryptionAlgorithmIdentifier(ContentEncryptionAlgorithmIdentifier.create((String)encryptedData.getAlgorithmOID()));
        try {
            encryptedContentInfo.setEncryptedContent(EncryptedContent.create((byte[])StreamTools.toByteArray((InputStream)encryptedData.getLocator().getInputStream())));
        }
        catch (IOException e) {
            throw new EncryptorException(e);
        }
        return encryptedContentInfo;
    }

    public ASN1ObjectIdentifier getContentType() {
        if (this.contentType == null) {
            this.contentType = CMSObjectIdentifiers.data;
        }
        return this.contentType;
    }

    public IEncryptor getDevice() {
        return this.device;
    }

    @Override
    public CMS process(ILocator source) throws EncryptorException {
        CMS cms = (CMS)CMS.FACTORY.createNew();
        EncryptedData data = (EncryptedData)EncryptedData.FACTORY.createNew();
        data.setEncryptedContentInfo(this.encrypt(source));
        data.setVersion(Version.create((int)0));
        cms.setEncryptedData(data);
        return cms;
    }

    public void setContentType(ASN1ObjectIdentifier contentType) {
        this.contentType = contentType;
    }
}

