/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.encryption;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.asn1.cms.ContentInfo;
import de.intarsys.asn1.cms.Digest;
import de.intarsys.asn1.cms.DigestedData;
import de.intarsys.asn1.common.AlgorithmIdentifier;
import de.intarsys.asn1.common.Version;
import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.method.cms.encryption.CommonPKCS7Encoder;
import de.intarsys.security.method.cms.encryption.EncryptorException;
import de.intarsys.security.method.cms.encryption.PKCS7DataEncoder;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

public class PKCS7DigestedDataEncoder
extends CommonPKCS7Encoder {
    private final IDigester digester;

    public PKCS7DigestedDataEncoder(IDigester digester) {
        this.digester = digester;
    }

    public IDigester getDigester() {
        return this.digester;
    }

    @Override
    public CMS process(ILocator locator) throws EncryptorException {
        PKCS7DataEncoder wrapper = new PKCS7DataEncoder();
        CMS contentInfo = wrapper.process(locator);
        IDigest digest = null;
        InputStream is = null;
        try {
            is = locator.getInputStream();
            digest = DigestTools.digest((IDigester)this.getDigester(), (InputStream)is);
        }
        catch (IOException e) {
            throw new EncryptorException(e);
        }
        finally {
            StreamTools.close((Closeable)is);
        }
        CMS cms = (CMS)CMS.FACTORY.createNew();
        DigestedData data = (DigestedData)DigestedData.FACTORY.createNew();
        data.setContentInfo((ContentInfo)contentInfo);
        data.setDigest(Digest.create((byte[])digest.getBytes()));
        String oid = DigestAlgorithm.lookupOID((String)digest.getAlgorithmName());
        data.setDigestAlgorithm(AlgorithmIdentifier.create((String)oid));
        data.setVersion(Version.create((int)0));
        cms.setDigestedData(data);
        return cms;
    }
}

